#include "ETUtility.h"
#include "Lcd.h"
#include "Bluetooth.h"
#include "BTConnection.h"
#include "TouchSensor.h"
#include "ETTailControl.h"
#include "Speaker.h"
#include "tsprintf.h"

using namespace ecrobot;

//#define PASS_KEY
/* 固有のパスキーを設定してください */
const char* ecrobot::ETBluetoothString::PASS_KEY = "1234"; 
/* リモートスタートコマンド */
const char ecrobot::ETBluetoothString::CMD_START = '1';
/* リモートストップコマンド */    
const char ecrobot::ETBluetoothString::CMD_STOP  = '9';    

bool ETUtilityStuff::IsBluetoothReceived(char cmd)
{
	int i;
    /* Bluetooth通信用データ受信バッファ */
    char rx_buf[BT_MAX_RX_BUF_SIZE];
	unsigned int rx_len;
	unsigned char come = 0;

	for (i=0; i<BT_MAX_RX_BUF_SIZE; i++)
	{
		rx_buf[i] = 0; /* 受信バッファをクリア */
	}

	rx_len = ecrobot_read_bt(rx_buf, 0, BT_MAX_RX_BUF_SIZE);
	if (rx_len > 0)
	{
		/* 受信データあり */
		if (rx_buf[0] == cmd)
		{
			come = 1; /* コマンド受信 */
		}
		ecrobot_send_bt(rx_buf, 0, rx_len); /* 受信データをエコーバック */
	}

	return (BOOL)come;
}

bool ETUtilityStuff::Istouched(ecrobot::TouchSensor& touch,ecrobot::ETTailControl& tailcontroler)
{
    tailcontroler.Control();
    if(touch.isPressed()){
	    systick_wait_ms(30);
        while(touch.isPressed()){
            tailcontroler.Control();
        }
	    systick_wait_ms(30);
        return true;
    }
    return false;
}

void ETUtilityStuff::Waitstart(ecrobot::TouchSensor& touch,ecrobot::ETTailControl& tailcontroler,char cmd)
{
    /* タッチセンサが押されるまで、待ち続ける */
    while(1){
	    if (Istouched(touch,tailcontroler)){
		    break;
	    }
	    if (IsBluetoothReceived(ETBluetoothString::CMD_START)){									
		    break;
	    }
    }
}

void ETUtilityStuff::DisplayCalibResult(Lcd& lcd,
                                        Speaker& speaker,
                                        char* disp,
                                        const unsigned long offset,
                                        const int tone,
                                        const unsigned long y)
{
	char str[16+1];
	tsprintf(str,disp,offset);
	lcd.cursor(0,y);
	lcd.putf("s",str);
	lcd.disp();
	speaker.playTone(tone,100,50);
}

