<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class ProfileTableStatic extends AppModel {

	var $name = 'ProfileTableStatic';

	var $fields = array(
		'edit' => array('profile_table_id', 'title', 'sort_order'),
		'escape' => array(
			'title' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
		),
	);

	var $validate = array(
		'title' => array(
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 64),
			),
		),
		'sort_order' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'allowEmpty' => true,
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'ProfileTable' => array(
			'className' => 'ProfileTable',
			'foreignKey' => 'profile_table_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	var $hasMany = array(
		'CharactersHasProfile' => array(
			'className' => 'CharactersHasProfile',
			'foreignKey' => 'profile_table_static_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

	/* コールバックメソッド */

	function afterSave($created) {
		$this->deleteCache4ProfileChilds();

		if (!isset($this->ProfileTable)) {
			$this->ProfileTable = CorePlus::set_model('ProfileTable');
		}
		$this->ProfileTable->cacheDelete();

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4ProfileChilds();

		if (!isset($this->ProfileTable)) {
			$this->ProfileTable = CorePlus::set_model('ProfileTable');
		}
		$this->ProfileTable->cacheDelete();

		return parent::afterDelete();
	}

}

