<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class SendMail extends AppModel {
	var $name = 'SendMail';

	var $fields = array(
		'add' => array('user_id', 'from', 'from_user_id', 'subject', 'body', 'useragent', 'host'),
		'escape' => array(
			'subject' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
			'body' => array(
				'html' => true,
				'tags' => true,
				'images' => true,
				'sctipts' => true,
			),
		),
	);

	var $validate = array(
		'from' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
			'isAddress' => array(
				'rule' => 'isAddress',
			),
		),
		'subject' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'body' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
	);

	var $belongsTo = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'fields' => array(
				'User.id', 
				'User.name',
				'User.pcmail'
			),
		),
		'FromUser' => array(
			'className' => 'User',
			'foreignKey' => 'from_user_id',
			'fields' => array(
				'FromUser.id', 
				'FromUser.name',
				'FromUser.pcmail'
			),
		),
	);
}
?>