/* ------------------------------------------------------------------------
	Class: prettyPopin
	Use: Alternative to popups
	Author: Stephane Caron (http://www.no-margin-for-errors.com)
	Version: 1.3
	customized
------------------------------------------------------------------------- */

var _followScroll = false;
var _readyBound = false;

(function($) {
	$.fn.prettyPopin = function(settings) {
		settings = jQuery.extend({
			modal : false, /* true/false */
			width : false, /* false/integer */
			height: false, /* false/integer */
			opacity: 0.5, /* value from 0 to 1 */
			animationSpeed: 'fast', /* slow/medium/fast/integer */
			followScroll: true, /* true/false */
			close : true, /* true/false */
			overflow : 'hidden', /* scroll/hidden */
			draggable : false, /* true/false */
			divname : 'prettyPopin',
			divname0 : 'prettyPopin1',
			internalname : 'internal',
			dirname : 'xoonips',
			loader_path: 'images/prettyPopin/loader.gif', /* path to your loading image */
			callback: function(){} /* callback called when closing the popin */
		}, settings);

		function bindReady(){ // To bind them only once
			if(_readyBound) return;
			_readyBound = true;
			$(window).scroll(function(){ _centerPopin(); });
			$(window).resize(function(){ _centerPopin(); });
		};
		bindReady();

		return this.each(function(){
			var popinWidth;
			var popinHeight;
			var $c;

			$(this).click(function(){
				
				buildoverlay();
				buildpopin();
				
				// Load the content
				$.get($(this).attr('href'),function(responseText){
					$('.' + settings.divname + ' .prettyContent .prettyContent-container').html(responseText);
					$('.' + settings.divname).css({'overflow': settings.overflow});
					if (settings.draggable) {
						$('.' + settings.divname).draggable();
					}
					// This block of code is used to calculate the width/height of the popin
					popinWidth = settings.width || $('.' + settings.divname + ' .prettyContent .prettyContent-container').width() + parseFloat($('.' + settings.divname + ' .prettyContent .prettyContent-container').css('padding-left')) + parseFloat($('.' + settings.divname + ' .prettyContent .prettyContent-container').css('padding-right'));
					$('.' + settings.divname).width(popinWidth);
					popinHeight = settings.height || $('.' + settings.divname + ' .prettyContent .prettyContent-container').height() + parseFloat($('.' + settings.divname + ' .prettyContent .prettyContent-container').css('padding-top')) + parseFloat($('.' + settings.divname + ' .prettyContent .prettyContent-container').css('padding-bottom'));
					$('.' + settings.divname).height(popinHeight);

					// Now reset the width/height
					$('.' + settings.divname).height(45).width(45);

					displayPopin();
				});
				return false;
			});

			var displayPopin = function() {
				var scrollPos = _getScroll();

				projectedTop = ($(window).height()/2) + scrollPos['scrollTop'] - (popinHeight/2);
				if(projectedTop < 0) {
					projectedTop = 10;
					_followScroll = false;
				}else{
					_followScroll = settings.followScroll;
				};

				$('.' + settings.divname).animate({
					'top': projectedTop,
					'left': ($(window).width()/2) + scrollPos['scrollLeft'] - (popinWidth/2),
					'width' : popinWidth,
					'height' : popinHeight
				},settings.animationSpeed, function(){
					displayContent();
				});
			};

			var buildpopin = function() {
				if(settings.close) {
					$('body').append('<div class=' + settings.divname + '><a href="#" id="b_close" rel="close">Close</a><div class="prettyContent"><img src="'+settings.loader_path+'" alt="Loading" class="loader" /><div class="prettyContent-container"></div></div></div>');
				}else{
					$('body').append('<div class=' + settings.divname + '><div class="prettyContent"><img src="'+settings.loader_path+'" alt="Loading" class="loader" /><div class="prettyContent-container"></div></div></div>');
				}
				$c = $('.' + settings.divname + ' .prettyContent .prettyContent-container'); // The content container

				$('.' + settings.divname + ' a[rel=close]:eq(0)').click(function(){ closeOverlay(); return false; });

				var scrollPos = _getScroll();

				// Show the popin
				$('.' + settings.divname).width(45).height(45).css({
					'top': ($(window).height()/2) + scrollPos['scrollTop'],
					'left': ($(window).width()/2) + scrollPos['scrollLeft']
				}).hide().fadeIn(settings.animationSpeed);
			};

			var buildoverlay = function() {
				$('body').append('<div id="overlay"></div>');

				// Set the proper height
				$('#overlay').css('height',$(document).height());

				// Fade it in
				$('#overlay').css('opacity',0).fadeTo(settings.animationSpeed,settings.opacity);

				if(settings.divname != settings.divname0 && $('.' + settings.divname0)) {
					$('.' + settings.divname0).css('opacity',0).fadeTo(settings.animationSpeed,settings.opacity);
				}
				if(!settings.modal){
					$('#overlay').click(function(){
						closeOverlay();
					});
				};
			};

			var displayContent = function() {
				if($('#autocallback').length) { callbackClick(); return false; };
				$c.parent().find('.loader').hide();
				$c.parent().parent().find('#b_close').show();
				$c.fadeIn(function(){
					// Focus on the first form input if there's one
					$(this).find('input[type=text]:first').trigger('focus');

					// Check for paging
					$('.' + settings.divname + " a[rel=internal]").click(function(){
						$link = $(this);

						// Fade out the current content
						$c.fadeOut(function(){
							$c.parent().find('.loader').show();

							// Submit the form
							$.get($link.attr('href'),function(responseText){
								// Replace the content
								$c.html(responseText);

								_refreshContent($c);
							});
						});
						return false;
					});

					// Submit the form in ajax
					$('.' + settings.divname + ' form[name!=' + settings.internalname + ']').bind('submit',function(){
						$theForm = $(this);
						// Fade out the current content
						$c.fadeOut(function(){
							$c.parent().find('.loader').show();
							// Submit the form
							$.post($theForm.attr('action'),$theForm.serialize(),function(responseText){
								// Replace the content
								$c.html(responseText);
								_refreshContent($c);
							});
						});
						return false;
					});
				});
				$('.' + settings.divname + ' a[rel=close]:gt(0)').click(function(){ closeOverlay(); return false; });
				$('.' + settings.divname + " :button[rel='cancel']").click(function() { cancelClick(); return false; });
				$('.' + settings.divname + " :button[rel='callback']").click(function() { callbackClick(); return false; });
			};

			var _refreshContent = function(){
				var scrollPos = _getScroll();

				if(!settings.width) popinWidth = $c.width() + parseFloat($c.css('padding-left')) + parseFloat($c.css('padding-right'));
				if(!settings.height) popinHeight = $c.height() + parseFloat($c.css('padding-top')) + parseFloat($c.css('padding-bottom'));

				projectedTop = ($(window).height()/2) + scrollPos['scrollTop'] - (popinHeight/2);
				if(projectedTop < 0) {
					projectedTop = 10;
					_followScroll = false;
				}else{
					_followScroll = settings.followScroll;
				};

				$('.' + settings.divname).animate({
					'top': projectedTop,
					'left': ($(window).width()/2) + scrollPos['scrollLeft'] - (popinWidth/2),
					'width' : popinWidth,
					'height' : popinHeight
				}, settings.animationSpeed,function(){
					displayContent();
				});
			};

			var closeOverlay = function() {
				if(settings.divname == settings.divname0 || !$('.prettyPopin').length || !$('.prettyPopin1').length) {
					$('#overlay').fadeOut(settings.animationSpeed,function(){ $(this).remove(); });
				} else {
					$('.' + settings.divname0).css('opacity',1).hide().fadeIn(settings.animationSpeed);
				};
				$('.' + settings.divname).fadeOut(settings.animationSpeed,function(){ 
					$(this).remove();
					//settings.callback()
				});
			};
			var cancelClick = function() {
				if(settings.divname == settings.divname0 || !$('.prettyPopin').length || !$('.prettyPopin1').length) {
					$('#overlay').fadeOut(settings.animationSpeed,function(){ $(this).remove(); });
				} else {
					$('.' + settings.divname0).css('opacity',1).hide().fadeIn(settings.animationSpeed);
				};
				$('.' + settings.divname).fadeOut(settings.animationSpeed,function(){
					$(this).remove();
					//settings.callback('')
				});
			};
			var callbackClick = function() {
				if(settings.divname == settings.divname0 || !$('.prettyPopin').length || !$('.prettyPopin1').length) {
					$('#overlay').fadeOut(settings.animationSpeed,function(){ $(this).remove(); });
				} else {
					$('.' + settings.divname0).css('opacity',1).hide().fadeIn(settings.animationSpeed);
				};
				$('.' + settings.divname).fadeOut(settings.animationSpeed,function() {
					settings.callback($('.' + settings.divname + ' #' + settings.dirname + '_callbackid').val(), $('.' + settings.divname + ' #' + settings.dirname + '_callbackvalue').val())
					$(this).remove();
				});
			};
		});

		function _centerPopin(){
			if(!_followScroll) return;

			// Make sure the popin exist
			if(!$('.' + settings.divname)) return;
			
			var scrollPos = _getScroll();

			if($.browser.opera) {
				windowHeight = window.innerHeight;
				windowWidth = window.innerWidth;
			}else{
				windowHeight = $(window).height();
				windowWidth = $(window).width();
			};

			projectedTop = ($(window).height()/2) + scrollPos['scrollTop'] - ($('.' + settings.divname).height()/2);
			if(projectedTop < 0) {
				projectedTop = 10;
				_followScroll = false;
			}else{
				_followScroll = true;
			};

			$('.' + settings.divname).css({
				'top': projectedTop,
				'left': ($(window).width()/2) + scrollPos['scrollLeft'] - ($('.' + settings.divname).width()/2)
			});
		};

		function _getScroll(){
			scrollTop = window.pageYOffset || document.documentElement.scrollTop || 0;
			scrollLeft = window.pageXOffset || document.documentElement.scrollLeft || 0;
			return {scrollTop:scrollTop,scrollLeft:scrollLeft};
		};
	};
	$.extend({
		prettyPopin1 : new function(settings) {
			this.internalSubmit = function(settings) {
				settings = jQuery.extend({
					width : false, /* false/integer */
					height: false, /* false/integer */
					opacity: 0.5, /* value from 0 to 1 */
					animationSpeed: 'fast', /* slow/medium/fast/integer */
					followScroll: true, /* true/false */
					close : false, /* true/false */
					divname : 'prettyPopin1',
					divname0 : 'prettyPopin1',
					internalname : 'internal',
					dirname : 'xoonips',
					targetframe : '#xoonips_registerform',
					loader_path: 'images/prettyPopin/loader.gif', /* path to your loading image */
					callback: function(){} /* callback called when closing the popin */
				}, settings);

				$theForm = $(settings.targetframe);
				popinWidth = $('.' + settings.divname).width();
				popinHeight = $('.' + settings.divname).height();
				$c = $('.' + settings.divname + ' .prettyContent .prettyContent-container'); // The content container

				// Fade out the current content
				$c.fadeOut(function(){
					$c.parent().find('.loader').show();

					// Submit the form
					$.post($theForm.attr('action'),$theForm.serialize(),function(responseText){
						// Replace the content
						$c.html(responseText);

						_refreshContent($c);
					});
				});

				var displayContent = function() {
					if($('#autocallback').length) { callbackClick(); return false; };
					$c.parent().find('.loader').hide();
					$c.parent().parent().find('#b_close').show();
					$c.fadeIn(function(){
						// Focus on the first form input if there's one
						$(this).find('input[type=text]:first').trigger('focus');

						// Check for paging
						$('.' + settings.divname + " a[rel=internal]").click(function(){
							$link = $(this);

							// Fade out the current content
							$c.fadeOut(function(){
								$c.parent().find('.loader').show();

								// Submit the form
								$.get($link.attr('href'),function(responseText){
									// Replace the content
									$c.html(responseText);

									_refreshContent($c);
								});
							});
							return false;
						});
						$('.' + settings.divname + ' form[name!=' + settings.internalname + ']').bind('submit',function(){
							$theForm = $(this);
							// Fade out the current content
							$c.fadeOut(function(){
								$c.parent().find('.loader').show();

								// Submit the form
								$.post($theForm.attr('action'),$theForm.serialize(),function(responseText){
									// Replace the content
									$c.html(responseText);

									_refreshContent($c);
								});
							});
							return false;
						});
					});
					$('.' + settings.divname + ' a[rel=close]:gt(0)').click(function(){ closeOverlay(); return false; });
					$('.' + settings.divname + " :button[rel='cancel']").click(function() { cancelClick(); return false; });
					$('.' + settings.divname + " :button[rel='callback']").click(function() { callbackClick(); return false; });
				};

				var _refreshContent = function(){
					var scrollPos = _getScroll();

					if(!settings.width) popinWidth = $c.width() + parseFloat($c.css('padding-left')) + parseFloat($c.css('padding-right'));
					if(!settings.height) popinHeight = $c.height() + parseFloat($c.css('padding-top')) + parseFloat($c.css('padding-bottom'));

					projectedTop = ($(window).height()/2) + scrollPos['scrollTop'] - (popinHeight/2);
					if(projectedTop < 0) {
						projectedTop = 10;
						_followScroll = false;
					}else{
						_followScroll = settings.followScroll;
					};

					$('.' + settings.divname).animate({
						'top': projectedTop,
						'left': ($(window).width()/2) + scrollPos['scrollLeft'] - (popinWidth/2),
						'width' : popinWidth,
						'height' : popinHeight
					}, settings.animationSpeed,function(){
						displayContent();
					});
				};

				var closeOverlay = function() {
					if(settings.divname == settings.divname0 || !$('.' + settings.divname0)) {
						$('#overlay').fadeOut(settings.animationSpeed,function(){ $(this).remove(); });
					} else {
						$('.' + settings.divname0).css('opacity',1).hide().fadeIn(settings.animationSpeed);
					};
					$('.' + settings.divname).fadeOut(settings.animationSpeed,function(){ 
						$(this).remove();
						//settings.callback()
					});
				};
				var cancelClick = function() {
					if(settings.divname == settings.divname0 || !$('.' + settings.divname0)) {
						$('#overlay').fadeOut(settings.animationSpeed,function(){ $(this).remove(); });
					} else {
						$('.' + settings.divname0).css('opacity',1).hide().fadeIn(settings.animationSpeed);
					};
					$('.' + settings.divname).fadeOut(settings.animationSpeed,function(){
						$(this).remove();
						//settings.callback('')
					});
				};
				var callbackClick = function() {
					if(settings.divname == settings.divname0 || !$('.' + settings.divname0)) {
						$('#overlay').fadeOut(settings.animationSpeed,function(){ $(this).remove(); });
					} else {
						$('.' + settings.divname0).css('opacity',1).hide().fadeIn(settings.animationSpeed);
					};
					$('.' + settings.divname).fadeOut(settings.animationSpeed,function() {
						settings.callback($('.' + settings.divname + ' #' + settings.dirname + '_callbackid').val(),$('.' + settings.divname + ' #' + settings.dirname + '_callbackvalue').val())
						$(this).remove();
					});
				};

				function _centerPopin(){
					if(!_followScroll) return;

					// Make sure the popin exist
					if(!$('.' + settings.divname)) return;
			
					var scrollPos = _getScroll();

					if($.browser.opera) {
						windowHeight = window.innerHeight;
						windowWidth = window.innerWidth;
					}else{
						windowHeight = $(window).height();
						windowWidth = $(window).width();
					};

					projectedTop = ($(window).height()/2) + scrollPos['scrollTop'] - ($('.' + settings.divname).height()/2);
					if(projectedTop < 0) {
						projectedTop = 10;
						_followScroll = false;
					}else{
						_followScroll = true;
					};

					$('.' + settings.divname).css({
						'top': projectedTop,
						'left': ($(window).width()/2) + scrollPos['scrollLeft'] - ($('.' + settings.divname).width()/2)
					});
				};

				function _getScroll(){
					scrollTop = window.pageYOffset || document.documentElement.scrollTop || 0;
					scrollLeft = window.pageXOffset || document.documentElement.scrollLeft || 0;
					return {scrollTop:scrollTop,scrollLeft:scrollLeft};
				};

			}
		}
	});
	$.fn.extend({
		prettyPopin1 : $.prettyPopin1.internalSubmit
	});
})(jQuery);
