// socket_send.c
// masashi shimakura 20140223 

#include<stdio.h>
#include<fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>

#include"libms.h"

// #define SOCKET_SENDBUG

int socket_send(int sk, char * senddata, int interval)
{
int retval, flag, ret, co;
struct timeval tv;
fd_set wfds;

// インターバルの設定
tv.tv_sec = interval;
tv.tv_usec = 0;
ret = 0;
co = 0;

// 非同期開始
flag=fcntl(sk, F_GETFL, 0);
fcntl(sk, F_SETFL, flag|O_NONBLOCK);

for(co =0; co < 20; co++){
   if((ret = send(sk, senddata, (int)strlen(senddata), 0)) < 0){
      // sendがエラーを返す
      if(errno == EAGAIN || errno == EWOULDBLOCK){
         // リソースなエラーの場合
         FD_ZERO(&wfds);
         FD_SET(sk, &wfds);
         // 書けるかのselectでFD変化を待つ
         retval = select(sk + 1, NULL, &wfds, NULL, &tv);
         if(retval < 0){
            // select失敗
            #ifdef SOCKET_SENDBUG
            printf("SOCKET_SENDBUG: socket_send(1): select失敗\n");
            #endif
            // 同期通信に戻す終了
            fcntl(sk, F_SETFL, 0);
            return -3;
            }
         else if(retval == 0){
            #ifdef SOCKET_SENDBUG
            printf("SOCKET_SENDBUG: socket_send(2): select　タイムアウト\n");
            #endif
            // selectタイムアウト
            // 同期通信に戻す終了
            fcntl(sk, F_SETFL, 0);
            return -2;
            }
         else{
            // 時間内にselect通過もういちど送信 forで10回繰り返す
            #ifdef SOCKET_SENDBUG
            printf("SOCKET_SENDBUG: socket_send(3): select　通過、もう一度カキコ co=%d\n", co);
            #endif
            }
         }
      else{
         // リソースエラー意外のエラー
         // 同期通信に戻す終了
         #ifdef SOCKET_SENDBUG
         printf("SOCKET_SENDBUG: socket_send(4): リソース意外のエラー  %s\n", strerror(errno));
         #endif
         fcntl(sk, F_SETFL, 0);
         return -1;
         }
      }
   else{
      // sendが素直に終了
      #ifdef SOCKET_SENDBUG
      printf("SOCKET_SENDBUG: socket_send(5): sendが素直に終了 %d\n", ret);
      #endif
      fcntl(sk, F_SETFL, 0);
      return ret;
      }
   usleep(200000);
   } // for()


#ifdef SOCKET_SENDBUG
printf("SOCKET_SENDBUG: socket_send(6): 繰り返し回数超過 %d\n", co);
#endif

// 同期通信に戻す
fcntl(sk, F_SETFL, flag);
return -4;
}





