#include "thcalcmd5.h"

#include <QDebug>

#include <QFile>
#include <QCryptographicHash>

ThCalcMD5::ThCalcMD5(QObject *parent) :
    QThread(parent)
{
    stopped = false;

    EvtQue = new QQueue<EventData>();
}

ThCalcMD5::~ThCalcMD5()
{
    delete EvtQue;
}

void ThCalcMD5::stop()
{
    stopped = true;
}

void ThCalcMD5::run()
{
    EventData event;
    int event_id;
    int status = 0; // 0 = idle, 1 = exec

    QString result = "";
    QCryptographicHash hash(QCryptographicHash::Md5);

    QFile in;
    char buf[8192];
    int bytesRead;
    quint64 filesize = 0;
    int totalread = 0;

    while (!stopped) {
        if (EvtQue->isEmpty()) {
            if (status == 1) {
                if ((bytesRead = in.read(buf, sizeof(buf))) > 0) {
                    hash.addData(buf, bytesRead);
                    totalread += bytesRead;
//                    qDebug() << "Progress = " << (((double)totalread / (double)filesize) * 100.0);
                    emit notify_calc_progress(((double)totalread / (double)filesize) * 100.0);
                } else {
                    result = hash.result().toHex();
                    emit notify_calc_progress(100);
                    emit notify_calc_end(result);
                    in.close();
                    status = 0;
                }
            } else {
                msleep(100);
            }
        } else {
            event = EvtQue->dequeue();
            event_id = event.id;
            switch(event_id) {
            case Ev_Start:
                if (status == 0) {
                    in.setFileName(event.param);
                    if (!in.open(QIODevice::ReadOnly)) {
                        emit notify_calc_end("");
                        return;
                    }
                    filesize = in.size();
                    totalread = 0;
                    status = 1;
                }
                break;
            case Ev_Stop:
                if (status == 1) {
                    in.close();
                    emit notify_calc_end("");
                    status = 0;
                }
                break;
            default:
                break;
            }
        }
    }

}

void ThCalcMD5::sendEvent_Start(QString filepath)
{
    EventData evt;

    evt.id = Ev_Start;
    evt.param = filepath;
    EvtQue->enqueue(evt);
}

void ThCalcMD5::sendEvent_Stop()
{
    EventData evt;

    evt.id = Ev_Stop;
    EvtQue->enqueue(evt);
}

