/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *		vZbTˑW[iM16Cpj
 */

#include "kernel_impl.h"

/*
 *  ݔ񐔂ۑϐ
 */
uint16_t intnest;

/* activate_contextŎgpꎞϐ */
uint8_t *tsk_sp;

/*
 *  CPUbNtÔ߂̕ϐ
 */
#if TIPM_LOCK != -7
bool_t		lock_flag;		/* CPUbNtO̒lێϐ */
uint16_t	saved_ipl;		/* ݗDxxۑϐ */
#endif	/* TIPM_LOCK != -7	*/

/*
 *  vZbTˑ̏
 */
void
prc_initialize(void)
{
	/*
	 *  CPUbNtÔ߂̕ϐ̏
	 */
#if TIPM_LOCK != -7
	lock_flag = true;
	saved_ipl = IPL_ENAALL;
#endif	/* TIPM_LOCK != -7	*/
}

/*
 *  vZbTˑ̏I
 */
void
prc_terminate(void)
{
	/* ɕKvȏ͂Ȃ */
}


/*
 *  CPUO̔󋵂̃Oo
 *
 *  CPUOnh̒CCPUO|C^ip_excinfjƂ
 *  ČĂяoƂŁCCPUO̔󋵂VXeOɏo͂D
 */
#ifdef SUPPORT_XLOG_SYS

void
xlog_sys(void *p_excinf)
{
	syslog(LOG_ERROR , "r0 = %u") , *((uint16_t*)((intptr_t)p_excinf + 0));
	syslog(LOG_ERROR , "r1 = %u") , *((uint16_t*)((intptr_t)p_excinf + 2));
	syslog(LOG_ERROR , "r2 = %u") , *((uint16_t*)((intptr_t)p_excinf + 4));
	syslog(LOG_ERROR , "r3 = %u") , *((uint16_t*)((intptr_t)p_excinf + 6));
	syslog(LOG_ERROR , "a0 = %x") , *((uint16_t*)((intptr_t)p_excinf + 8));
	syslog(LOG_ERROR , "a2 = %x") , *((uint16_t*)((intptr_t)p_excinf + 10));
	syslog(LOG_ERROR , "sb = %x") , *((uint16_t*)((intptr_t)p_excinf + 12));
	syslog(LOG_ERROR , "fb = %x") , *((uint16_t*)((intptr_t)p_excinf + 14));
	syslog(LOG_ERROR , "pc = %x") , *((uint32_t*)((intptr_t)p_excinf + 16));
	syslog(LOG_ERROR , "flg = %x") , *((uint16_t*)((intptr_t)p_excinf + 20));
}

#endif /* SUPPORT_XLOG_SYS */

/*
 *  ݗvC̑̐ݒ
 *
 *  ASPJ[lł̗pz肵āCp[^G[̓AT[VŃ`Fb
 *  NĂDcfg_intT[rXR[݂ꍇɂ́CG[Ԃ悤
 *  ɂׂł낤D
 */
void
x_config_int(INTNO intno, ATR intatr, PRI intpri)
{
	assert(VALID_INTNO_CFGINT(intno));
	assert(TMIN_INTPRI <= intpri && intpri <= TMAX_INTPRI);
	
	/*
	 *  ݂̃}XN
	 *
	 *  ݂󂯕t܂܁CxgK^GbWgK̐ݒC
	 *  ݗDx̐ݒŝ͊댯Ȃ߁Cݑɂ炸C
	 *  U}XND
	 */
	(void) x_disable_int(intno);
	
	/* INT[q̏ꍇ͊݌m@ݒ肷 */
	/* xgKAINT݈ȊO̓RtBO[^ňُƂB */
	if((intatr & TA_POSEDGE) != 0U)
	{
		/* オGbW */
		*(intc_reg[intno]) |= INTC_POLHIGH;
	}
	else
	{
		/* GbW */
		*(intc_reg[intno]) &= ~INTC_POLHIGH;

		/* GbW */
		if((intatr & TA_BOTHEDGE) != 0U)
		{
			m16c_config_int(intno);
		}
	}

	/*
	 *  M16Cł͊݋֎~/ݗDxݒŎ邽߁A
	 *  ŊݗDx̐ݒ͍sȂ
	 */

	/*
	 *  ݂̃}XN
 	 */
	if ((intatr & TA_ENAINT) == TA_ENAINT) {
		(void) x_enable_int(intno);
	}
}
