/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: semaphore.h 264 2007-07-12 08:23:10Z hiro $
 */

/*
 *		Z}tH@\
 */

#ifndef TOPPERS_SEMAPHORE_H
#define TOPPERS_SEMAPHORE_H

#include <queue.h>

/*
 *  Z}tHubN
 *
 *  ̍\̂́CEʐMIuWFNg̏ubN̋ʕ
 *  iWOBJINIBjgiIuWFNgw̌pɑĵŁC
 *  ŏ̃tB[hʂɂȂĂD
 */
typedef struct semaphore_initialization_block {
	ATR			sematr;			/* Z}tH */
	uint_t		isemcnt;		/* Z}tH̎̏l */
	uint_t		maxsem;			/* Z}tH̍ő厑 */
} SEMINIB;

/*
 *  Z}tHǗubN
 *
 *  ̍\̂́CEʐMIuWFNg̊ǗubN̋ʕiWOBJCBj
 *  giIuWFNgw̌pɑĵŁCŏ2
 *  tB[hʂɂȂĂD
 */
typedef struct semaphore_control_block {
	QUEUE		wait_queue;		/* Z}tH҂L[ */
	const SEMINIB *p_seminib;	/* ubNւ̃|C^ */
	uint_t		semcnt;			/* Z}tH݃JEgl */
} SEMCB;

/*
 *  Z}tH҂ubN̒`
 *
 *  ̍\̂́CEʐMIuWFNg̑҂ubN̋ʕ
 *  iWINFO_WOBJjgiIuWFNgw̌pɑĵŁC
 *  ׂẴtB[hʂɂȂĂD
 */
typedef struct semaphore_waiting_information {
	WINFO	winfo;			/* W̑҂ubN */
	SEMCB	*p_semcb;		/* ҂ĂZ}tH̊ǗubN */
} WINFO_SEM;

/*
 *  Z}tHID̍őlikernel_cfg.cj
 */
extern const ID	tmax_semid;

/*
 *  Z}tHubÑGAikernel_cfg.cj
 */
extern const SEMINIB	seminib_table[];

/*
 *  Z}tHǗubÑGAikernel_cfg.cj
 */
extern SEMCB	semcb_table[];

/*
 *  Z}tHǗubNZ}tHIDo߂̃}N
 */
#define	SEMID(p_semcb)	((ID)(((p_semcb) - semcb_table) + TMIN_SEMID))

/*
 *  Z}tH@\̏
 */
extern void	initialize_semaphore(void);

#endif /* TOPPERS_SEMAPHORE_H */
