/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2006-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: test_tex1.c 818 2008-03-18 12:56:15Z hiro $
 */

/* 
 *		^XNOɊւeXg(1)
 *
 * yeXg̖ړIz
 *
 *  ^XN^XNO[`N鏈ԗIɃeXgD
 *
 * yeXgځz
 *
 *	(A) ras_texCref_tex̃G[o
 *		(A-1) Ώۃ^XNx~
 *		(A-2) Ώۃ^XÑ^XNO[``ĂȂ
 *	(B) dis_texCena_tex̃G[o
 *		(B-1) ^XÑ^XNO[``ĂȂ
 *	(C) ras_tex̐폈
 *		(C-1) Ώۃ^XN^XN^XNOŁCɋN
 *		(C-2) Ώۃ^XN^XNłȂ
 *		(C-3) Ώۃ^XN^XN^XNO֎~
 *	(D) ena_tex̐폈
 *		(D-1) ^XNOvCɋN
 *		(D-2) ^XNOvȂ
 *	(E) ^XNfBXpb`ɂN
 *		(E-1) fBXpb`̃^XN^XNOŃ^XNOv
 *			  
 *	(F) ^XNO[`̃^[ɂNiANj
 *	(G) ^XNO[`̖߂莞ɂԕA
 *		(G-1) ^XNɖ߂Ă鎞
 *		(G-2) ^XNO[`AN鎞
 *	(H) ^XNO[`̑dN
 *	(I) ^XNO[`̖߂莞̃^XN؊
 *
 * ygp\[Xz
 *
 *	TASK1: C̃^XND^XNɑ΂ă^XNOv
 *	TASK2: ^XNɑ΂ă^XNOvΏۃ^XN
 *	TASK3: ^XNO[``ĂȂ^XN
 *	TASK4: x~Ԃ̃^XN
 *
 * yeXgV[PXz
 *
 *	== TASK1iDxF10j==
 *	1:	Ԃ̃`FbN
 *		ref_tex(TSK_SELF, &rtex)
 *		ras_tex(TASK3, 0x0001)		... (A-2)
 *		ras_tex(TASK4, 0x0001)		... (A-1)
 *		ref_tex(TASK3, &rtex)		... (A-2)
 *		ref_tex(TASK4, &rtex)		... (A-1)
 *	2:	ena_tex()					... (D-2)
 *		ref_tex(TSK_SELF, &rtex)
 *	3:	ras_tex(TSK_SELF, 0x0001)	... (C-1)
 *	== TASK1^XNO[`i1ځj==
 *	4:	Ԃ̃`FbN
 *	5:	dis_dsp() ... 4̏Ԃꂼω
 *		chg_ipm(TMAX_INTPRI)
 *		ena_tex()
 *		loc_cpu()
 *		^[
 *	== TASK1ij==
 *	6:	߂ĂԂ̃`FbN	... (G-1)
 *	7:	dis_dsp() ... 3̏Ԃꂼω
 *		chg_ipm(TMIN_INTPRI)
 *		dis_tex()
 *	8:	ras_tex(TASK1, 0x0002)		... (C-3)
 *		ref_tex(TSK_SELF, &rtex)
 *	9:	ena_tex()					... (D-1)
 *	== TASK1^XNO[`i2ځj==
 *	10:	Ԃ̃`FbN
 *	11:	ras_tex(TASK1, 0x0001)		... (C-3)
 *		ras_tex(TASK1, 0x0002)		... (C-3)
 *	12:	ena_dsp() ... 3̏Ԃꂼω
 *		chg_ipm(TMAX_INTPRI)
 *		loc_cpu()
 *		^[					... (F)
 *	== TASK1^XNO[`i3ځj==
 *	13:	Ԃ̃`FbN
 *	14:	ena_dsp() ... 3̏Ԃꂼω
 *		chg_ipm(TMAX_INTPRI)
 *		ena_tex()
 *	15: ras_tex(TSK_SELF, 0x0004)	... (H)
 *	== TASK1^XNO[`i4ځj==
 *	16:	Ԃ̃`FbN
 *	17:	dis_dsp() ... 3̏Ԃꂼω
 *		chg_ipm(TIPM_ENAALL)
 *		loc_cpu()
 *		^[
 *	== TASK1^XNO[`i3ڑj==
 *	18:	߂ĂԂ̃`FbN	... (G-2)
 *		^[
 *	== TASK1ij==
 *	19:	߂ĂԂ̃`FbN	... (G-1)
 *	20: ena_dsp()
 *		chg_ipm(TIPM_ENAALL)
 *		rot_rdq(TPRI_SELF)
 *	== TASK2iDxF10j	==
 *	21:	Ԃ̃`FbN
 *	22:	ena_tex()
 *		rot_rdq(TPRI_SELF)
 *	== TASK3iDxF10j	==
 *	23:	Ԃ̃`FbN
 *	24:	ena_tex()
 *	25:	dis_tex()					... (B-1)
 *		ext_tsk()					... (B-1)
 *	== TASK1ij==
 *	26: ras_tex(TASK2, 0x0001)		... (C-2)
 *		ref_tex(TASK2, &rtex)
 *	27:	rot_rdq(TPRI_SELF)			... (E-1)
 *	== TASK2^XNO[`i1ځj==
 *	28:	Ԃ̃`FbN
 *		^[
 *	== TASK2ij==
 *	29: ras_tex(TSK_SELF, 0x0002)
 *	== TASK2^XNO[`i2ځj==
 *	30:	Ԃ̃`FbN
 *	31:	dis_dsp
 *		rot_rdq(TPRI_SELF)
 *	32:	^[					... (I)
 *	== TASK1ij==
 *	33:	^[i^XNIj
 *	== TASK2ij==
 *	34:	eXgI
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_tex1.h"

void
tex_task1(TEXPTN texptn, intptr_t exinf)
{
	ER		ercd;

	switch (texptn) {
	case 0x0001:
		check_point(4);
		check_state(false, false, TIPM_ENAALL, false, false, true);

		/*
		 *  fBXpb`֎~CݗDx}XNύXC^XNO
		 */
		check_point(5);
		ercd = dis_dsp();
		check_ercd(ercd, E_OK);
		ercd = chg_ipm(TMAX_INTPRI);
		check_ercd(ercd, E_OK);
		ercd = ena_tex();
		check_ercd(ercd, E_OK);
		ercd = loc_cpu();
		check_ercd(ercd, E_OK);
		check_state(false, true, TMAX_INTPRI, true, true, false);
		break;

	case 0x0002:
		check_point(10);
		check_state(false, false, TMIN_INTPRI, true, true, true);

		/*
		 *  ^XNOv
		 */
		check_point(11);
		ercd = ras_tex(TSK_SELF, 0x0001);
		check_ercd(ercd, E_OK);
		ercd = ras_tex(TSK_SELF, 0x0002);
		check_ercd(ercd, E_OK);

		/*
		 *  fBXpb`CݗDx}XNύXCCPUbN
		 */
		check_point(12);
		ercd = ena_dsp();
		check_ercd(ercd, E_OK);
		ercd = chg_ipm(TMAX_INTPRI);
		check_ercd(ercd, E_OK);
		ercd = loc_cpu();
		check_ercd(ercd, E_OK);
		check_state(false, true, TMAX_INTPRI, false, true, true);
		break;

	case 0x0003:
		check_point(13);
		check_state(false, false, TMIN_INTPRI, true, true, true);

		/*
		 *  fBXpb`CݗDx}XNύXC^XNO
		 */
		check_point(14);
		ercd = ena_dsp();
		check_ercd(ercd, E_OK);
		ercd = chg_ipm(TMAX_INTPRI);
		check_ercd(ercd, E_OK);
		ercd = ena_tex();
		check_ercd(ercd, E_OK);
		check_state(false, false, TMAX_INTPRI, false, true, false);

		/*
		 *  ^XNOv
		 */
		check_point(15);
		ercd = ras_tex(TSK_SELF, 0x0004);
		/* Ń^XNO[`삷 */
		check_ercd(ercd, E_OK);

		/*
		 *  ^XNÕ^[ɂ茳̏Ԃɖ߂Ă邱
		 *  `FbN
		 */
		check_point(18);
		check_state(false, false, TMAX_INTPRI, false, true, false);
		break;

	case 0x0004:
		check_point(16);
		check_state(false, false, TMAX_INTPRI, false, true, true);

		/*
		 *  fBXpb`֎~CݗDx}XNύXCCPUbN
		 */
		check_point(17);
		ercd = dis_dsp();
		check_ercd(ercd, E_OK);
		ercd = chg_ipm(TIPM_ENAALL);
		check_ercd(ercd, E_OK);
		ercd = loc_cpu();
		check_ercd(ercd, E_OK);
		check_state(false, true, TIPM_ENAALL, true, true, true);
		break;

	default:
		check_point(0);
		break;
	}
}

void
task1(intptr_t exinf)
{
	ER		ercd;
	T_RTEX	rtex;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(1);
	check_state(false, false, TIPM_ENAALL, false, false, true);
	ercd = ref_tex(TSK_SELF, &rtex);
	check_ercd(ercd, E_OK);
	check_assert((rtex.texstat & TTEX_DIS) != 0);
	check_assert(rtex.pndptn == 0);

	/*
	 *  ras_tex̃G[o
	 */
	ercd = ras_tex(TASK3, 0x0001);
	check_ercd(ercd, E_OBJ);
	ercd = ras_tex(TASK4, 0x0001);
	check_ercd(ercd, E_OBJ);

	/*
	 *  ref_tex̃G[o
	 */
	ercd = ref_tex(TASK3, &rtex);
	check_ercd(ercd, E_OBJ);
	ercd = ref_tex(TASK4, &rtex);
	check_ercd(ercd, E_OBJ);

	/*
	 *  ^XNŐ
	 */
	check_point(2);
	ercd = ena_tex();
	check_ercd(ercd, E_OK);
	check_state(false, false, TIPM_ENAALL, false, false, false);
	ercd = ref_tex(TSK_SELF, &rtex);
	check_ercd(ercd, E_OK);
	check_assert((rtex.texstat & TTEX_ENA) != 0);
	check_assert(rtex.pndptn == 0);

	/*
	 *  ^XNOv
	 */
	check_point(3);
	ercd = ras_tex(TSK_SELF, 0x0001);
	/* Ń^XNO[`삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  ^XNÕ^[ɂ茳̏Ԃɖ߂Ă邱Ƃ
	 *  `FbN
	 */
	check_point(6);
	check_state(false, false, TIPM_ENAALL, false, false, false);

	/*
	 *  fBXpb`֎~CݗDx}XNύXC^XNO֎~
	 */
	check_point(7);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);
	ercd = chg_ipm(TMIN_INTPRI);
	check_ercd(ercd, E_OK);
	ercd = dis_tex();
	check_ercd(ercd, E_OK);
	check_state(false, false, TMIN_INTPRI, true, true, true);

	/*
	 *  ^XNOv
	 */
	check_point(8);
	ercd = ras_tex(TASK1, 0x0002);
	check_ercd(ercd, E_OK);
	ercd = ref_tex(TSK_SELF, &rtex);
	check_ercd(ercd, E_OK);
	check_assert((rtex.texstat & TTEX_DIS) != 0);
	check_assert(rtex.pndptn == 0x0002);

	/*
	 *  ^XNO
	 */
	check_point(9);
	ercd = ena_tex();
	/* Ń^XNO[`삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  ^XNÕ^[ɂ茳̏Ԃɖ߂Ă邱Ƃ
	 *  `FbN
	 */
	check_point(19);
	check_state(false, false, TMIN_INTPRI, true, true, false);

	/*
	 *  ^XN2ɐ؂芷
	 */
	check_point(20);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);
	ercd = chg_ipm(TIPM_ENAALL);
	check_ercd(ercd, E_OK);
	ercd = rot_rdq(TPRI_SELF);
	/* ő̃^XN삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  ^XN2ɑ΂ă^XNOv
	 */
	check_point(26);
	ercd = ras_tex(TASK2, 0x0001);
	check_ercd(ercd, E_OK);
	ercd = ref_tex(TASK2, &rtex);
	check_ercd(ercd, E_OK);
	check_assert((rtex.texstat & TTEX_ENA) != 0);
	check_assert(rtex.pndptn == 0x0001);

	/*
	 *  ^XN2ɐ؂芷
	 */
	check_point(27);
	ercd = rot_rdq(TPRI_SELF);
	/* ő̃^XN삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  ^XNI
	 */
	check_point(33);
}

void
tex_task2(TEXPTN texptn, intptr_t exinf)
{
	ER		ercd;

	switch (texptn) {
	case 0x0001:
		check_point(28);
		check_state(false, false, TIPM_ENAALL, false, false, true);
		break;

	case 0x0002:
		check_point(30);
		check_state(false, false, TIPM_ENAALL, false, false, true);

		/*
		 *  fBXpb`֎~āC^XN؊vD
		 */
		check_point(31);
		ercd = dis_dsp();
		check_ercd(ercd, E_OK);
		ercd = rot_rdq(TPRI_SELF);
		check_ercd(ercd, E_OK);

		/*
		 *  ^XNO[`̃^[ŁC^XN؊
		 *  D
		 */
		check_point(32);
		break;

	default:
		check_point(0);
		break;
	}
}

void
task2(intptr_t exinf)
{
	ER		ercd;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(21);
	check_state(false, false, TIPM_ENAALL, false, false, true);

	/*
	 *  ^XNŐ
	 */
	check_point(22);
	ercd = ena_tex();
	check_ercd(ercd, E_OK);
	check_state(false, false, TIPM_ENAALL, false, false, false);

	/*
	 *  ^XN3ɐ؂芷
	 */
	ercd = rot_rdq(TPRI_SELF);
	/* ő̃^XN삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  ^XNOv
	 */
	check_point(29);
	ercd = ras_tex(TSK_SELF, 0x0002);
	/* Ń^XNO[`삷 */
	check_ercd(ercd, E_OK);

	/*
	 *  eXgI
	 */
	check_finish(34);
}

void
task3(intptr_t exinf)
{
	ER		ercd;

	/*
	 *  Ԃ̃`FbN
	 */
	check_point(23);
	check_state(false, false, TIPM_ENAALL, false, false, true);

	/*
	 *  ^XNŐ
	 */
	check_point(24);
	ercd = ena_tex();
	check_ercd(ercd, E_OBJ);
	check_state(false, false, TIPM_ENAALL, false, false, true);

	/*
	 *  ^XNŐ֎~
	 */
	check_point(25);
	ercd = dis_tex();
	check_ercd(ercd, E_OBJ);
	check_state(false, false, TIPM_ENAALL, false, false, true);

	/*
	 *  ^XNI
	 */
	ercd = ext_tsk();
	check_point(0);
}

void
task4(intptr_t exinf)
{
	check_point(0);
}

void
tex_task4(TEXPTN texptn, intptr_t exinf)
{
	check_point(0);
}
