/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 *		vZbT̓ꖽ߂̃CC֐`iM16Cpj
 */

#ifndef	TOPPERS_PRC_INSN_H
#define	TOPPERS_PRC_INSN_H

#define FLG_I_MASK		(0x0040u)
#define FLG_IPL_MASK	(0x7000u)

Inline volatile unsigned short current_flgreg(void);
Inline uint16_t current_ipl( void );


/*
 *  tOWX^(FLG)̌ݒl̓Ǐo
 */

Inline volatile uint16_t
current_flgreg(void)
{
	volatile uint16_t flg;
	Asm("	stc flg, $$[FB]", flg);
	return(flg);
}


/*
 *  tOWX^iFLGǰݒl̓Ǐo
 */
Inline uint16_t
current_ipl( void )
{
	volatile uint16_t	ipl;
	Asm("	stc flg, $$[FB]", ipl);
	return ipl;
}

/*
 *  tOWX^iFLGǰݒl̐ݒ
 */

/*
 *  IPL̐ݒ
 */
Inline void
set_ipl(uint16_t ipl)
{
	volatile uint16_t flg_reg = ipl;
	Asm("	ldc $$[FB], flg", flg_reg);
}

/*
 *  NMIׂĂ݂̊̋֎~
 */
Inline void
disint(void)
{
	Asm("	fclr	i");
}

/*
 *  ׂĂ݂̊̋
 */
Inline void
enaint(void)
{
	Asm("	fset	i");
}

#endif /* TOPPERS_PRC_INSN_H */
