/*
 * OpenI2CRADIO
 * Config & Main routine.
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <signal.h>
#include <delay.h>

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"

/*
 * Config words.
 */
__at(__CONFIG1H) _config1h = _FOSC_INTIO67_1H;
__at(__CONFIG2L) _config2l = _BORV_190_2L & _BOREN_ON_2L & _PWRTEN_ON_2L;
__at(__CONFIG2H) _config2h = _WDTEN_ON_2H & _WDTPS_32768_2H;
__at(__CONFIG3H) _config3h = _PBADEN_OFF_3H & _MCLRE_EXTMCLR_3H;
__at(__CONFIG4L) _config4l = _STVREN_ON_4L & _LVP_OFF_4L & _XINST_ON_4L & _DEBUG_ON_4L;
__at(__CONFIG5L) _config5l = _CP0_OFF_5L & _CP1_OFF_5L;
__at(__CONFIG5H) _config5h = _CPB_OFF_5H & _CPD_OFF_5H;
__at(__CONFIG6L) _config6l = _WRT0_OFF_6L & _WRT1_OFF_6L;
__at(__CONFIG6H) _config6h = _WRTD_OFF_6H & _WRTB_OFF_6H & _WRTC_OFF_6H;
__at(__CONFIG7L) _config7l = _EBTR0_OFF_7L & _EBTR1_OFF_7L;
__at(__CONFIG7H) _config7h = _EBTRB_OFF_7H;



SIGHANDLER(TMR0_handler)
{
   unsigned char tmr0f;
   unsigned char t0con;

   // Stop timer0
   t0con = T0CON;
   t0con &= ~_IDLEN;
   T0CON = t0con;

   // Read IOKEYS
   readkey_io();

   // Clear interrupt flag
   tmr0f = INTCON;
   tmr0f &= ~(_TMR0IF);
   INTCON = tmr0f;

   return;
}


DEF_INTLOW(intlow_handler)
  DEF_HANDLER(SIG_TMR0, TMR0_handler)
END_DEF


unsigned int amfreq;
unsigned int fmfreq;
unsigned char amband;
unsigned char fmband;
unsigned char fm;
unsigned char am_mode3k;
int recv_signal;




static void update_display(void)
{
    if(fm != 0){ // FM
        _LOCATE(0,0);
        if(fmband < AKC6955_BAND_TV1) {
            printstr("FM");
            _PUTCHAR('1' + (fmband & 7));
        } else if(fmband < AKC6955_BAND_FMUSER){
            printstr("TV");
            _PUTCHAR('1' + fmband - AKC6955_BAND_TV1);
        } else { // USER
            printstr("FMUSR");
        }
    } else { // AM
        _LOCATE(0,1);
        if(amband == AKC6955_BAND_LW) {
            printstr("LW");
        } else if(amband <AKC6955_BAND_SW1) { //MW
            printstr("MW");
            _PUTCHAR('1' + amband - AKC6955_BAND_MW1);
        } else if(amband < AKC6955_BAND_AMUSER) { //MW
            printstr("SW");
            _PUTCHAR('1' + amband - AKC6955_BAND_SW1);
        } else if(amband == AKC6955_BAND_MW4){
            printstr("MW4");
        } else {
            printstr("AMUSR");
        }
     }
     _LOCATE(16-4 ,1);
     if(fm != 0){
         printstr("MHz");
     } else {
         printstr("KHz");
     }
     _LOCATE(16-5, 1);
     if(fm != 0){
         int freq_lo = fmfreq % 100;
         int freq_hi = fmfreq / 100;
         print_numeric(freq_hi);
         _PUTCHAR('.');
         print_numeric(freq_lo);
     } else {
         int freq = amfreq;
         print_numeric(freq);
     }
     // Signal
     _LOCATE(0, 0);
     printstr("S=");
     print_numeric(recv_signal);
}


static void setfreq_updown(unsigned char ctlword)
{
    switch(ctlword){
        case charcode_8: // Change band
            if(fm != 0){
                amband++;
                if(amband > 18) amband = 0;
//                amfreq = akc6955_setfreq(amfreq)
                akc6955_set_amband(amband);
                delay1ktcy(500); // 62.5ms
                amband = akc6955_get_amband();
                amfreq = akc6955_get_freq();
            } else {
                fmband++;
                if(fmband > 7) fmband = 0;
//                amfreq = akc6955_setfreq(amfreq)
                akc6955_set_fmband(fmband);
                delay1ktcy(500); // 62.5ms
                fmband = akc6955_get_fmband();
                fmfreq = akc6955_get_freq();
            }
            break;
        case charcode_2: // Change band
            if(fm != 0){
                amband--;
                if(amband == 0) amband = 18;
                if(amband >= 18) amband = 18;
//                amfreq = akc6955_setfreq(amfreq)
                akc6955_set_amband(amband);
                delay1ktcy(500); // 62.5ms
                amband = akc6955_get_amband();
                amfreq = akc6955_get_freq();
            } else {
                fmband--;
                if(fmband == 0) fmband = 7;
                if(fmband >= 7) fmband = 7;
//                amfreq = akc6955_setfreq(amfreq)
                akc6955_set_fmband(fmband);
                delay1ktcy(500); // 62.5ms
                fmband = akc6955_get_fmband();
                fmfreq = akc6955_get_freq();
            }
            break;
        case charcode_4: // Down Freq;
            if(fm != 0){
                fmfreq = akc6955_down_freq(10); // DOWN 100KHz
            } else {
                amfreq = akc6955_down_freq(10); // DOWN 10KHz
            }
            break;
        case charcode_6: // Down Freq;
            if(fm != 0){
                fmfreq = akc6955_up_freq(10); // UP 100KHz
            } else {
                amfreq = akc6955_up_freq(10); // UP 10KHz
            }
            break;
        case charcode_7: // Down Fast;
            if(fm != 0){
                fmfreq = akc6955_down_freq(50); // DOWN 500KHz
            } else {
                amfreq = akc6955_down_freq(50); // DOWN 50KHz
            }
            break;
        case charcode_9: // Down Fast;
            if(fm != 0){
                fmfreq = akc6955_up_freq(50); // UP 100KHz
            } else {
                amfreq = akc6955_up_freq(50); // UP 10KHz
            }
            break;
        case charcode_1: // Down Slow;
            if(fm != 0){
                fmfreq = akc6955_down_freq(5); // DOWN 50KHz
            } else {
                amfreq = akc6955_down_freq(5); // DOWN 50KHz
            }
            break;
        case charcode_3: // Down Slow;
            if(fm != 0){
                fmfreq = akc6955_up_freq(5); // UP 50KHz
            } else {
                amfreq = akc6955_up_freq(5); // UP 5KHz
            }
            break;
        case charcode_0: // Step
            if(fm == 0){
                if(am_mode3k == 0) {
                    am_mode3k = 0xff;
                } else {
                    am_mode3k = 0;
                }
                amfreq = akc6955_mode3k(am_mode3k);
            }
            break;
        default:
            break;
    }
}
/*
 * 
 */
int main(void)
{
    char readchar;
    unsigned char input_flag;

    keyin_init();
    keyin_ioinit();
    idle_init();

    i2c1_init();

    delay1ktcy(1000); // Wait 125ms

    acm1602_init(0xa0, 1); //Init LCD

    delay1ktcy(1000); // Wait 125ms

    
    // Init AKC6955
    amfreq = 954;
    fmfreq = 8000; // 10KHz order.
    amband = AKC6955_BAND_MW2;
    fmband = AKC6955_BAND_FM2;
    am_mode3k = 0xff;
    fm = 0;
    recv_signal = 0;

    /* Check EEPROM */
    /* Push default parameters to AKC6955*/
    
    akc6955_chg_fm(fm); // Set to AM
    akc6955_set_amband(amband);
    akc6955_set_freq(amfreq); // Dummy, TBS (954KHz)
    akc6955_set_power(0xff); // Power ON
    idle(0xff00);
    do {
        /* Main routine*/
        input_flag = readkey_compare();
        if(input_flag != 0){
            readchar = pop_keyinfifo();
            switch(readchar) {
                // Top of input-tree.
                case charcode_s0:
                    // Change FM/AM
                    if(fm != 0){
                        fm = 0;
                        akc6955_chg_fm(fm);
                        akc6955_set_amband(amband);
                        akc6955_set_freq(amfreq);
                    } else {
                        fm = 0xff;
                        akc6955_chg_fm(fm);
                        akc6955_set_fmband(fmband);
                        akc6955_set_freq(fmfreq);
                    }
                    break;
                case charcode_s1:
                    // 
                    break;
                case charcode_s2:
                    // ENTER
                    break;
                case charcode_s3:
                    // Reserve
                    break;
                case charcode_null: // None
                    break;
                default:
                    // Numeric 0to9, or a to f.
                    setfreq_updown(readchar);
                    break;
            }
        }
        recv_signal = akc6955_read_level();
        // Check battery (include idle?)
        // Read AKJC6955's status
        // Putstring to LCD.
        update_display();
        idle(0xff00);
    } while(1);

}

