/*
 * OpenI2CRADIO
 * UI Handler
 * (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2
 */

#ifndef UI_H
#define	UI_H

#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */

#include "lcd_acm1602.h"
#include "iodef.h"

#ifdef	__cplusplus
extern "C" {
#endif

extern keyin_defs keyin_old[2];
extern keyin_defs keyin_now;
extern char keyin_fifo[16];
extern char keyin_nowp;
extern char keyin_counter;

#define _LOCATE(x,y) acm1602_locate(0xa0, x, y)
#define _PUTCHAR(c) acm1602_putchar(0xa0, c)
#define _CURSOR_LEFT() acm1602_cursordir(0xa0, 0x00);
#define _CURSOR_RIGHT() acm1602_cursordir(0xa0, 0xff);

extern void keyin_init(void);
extern void keyin_ioinit(void);
extern void push_keyinfifo(char b);
extern char pop_keyinfifo(void);
extern void readkey_io(void);
extern unsigned char readkey_compare(void);

extern void printstr(char *s);
extern void print_numeric(int i);


#ifdef	__cplusplus
}
#endif

#endif	/* UI_H */

