/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ResponseUtils;

public class HtmlTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected boolean locale = false;
    protected boolean xhtml = false;

    public boolean getLocale() {
        return this.locale;
    }

    public void setLocale(boolean locale) {
        this.locale = locale;
    }

    public boolean getXhtml() {
        return this.xhtml;
    }

    public void setXhtml(boolean xhtml) {
        this.xhtml = xhtml;
    }

    public int doStartTag() throws JspException {
        String lang;
        StringBuffer sb = new StringBuffer("<html");
        Locale currentLocale = this.currentLocale();
        if (currentLocale != null && (lang = currentLocale.getLanguage()) != null && lang.length() > 0) {
            sb.append(" lang=\"");
            sb.append(lang);
            sb.append("\"");
            if (this.xhtml) {
                sb.append(" xml:lang=\"");
                sb.append(lang);
                sb.append("\"");
            }
        }
        sb.append(">");
        ResponseUtils.write(this.pageContext, sb.toString());
        return 1;
    }

    public int doEndTag() throws JspException {
        ResponseUtils.write(this.pageContext, "</html>");
        return 6;
    }

    public void release() {
        this.locale = false;
        this.xhtml = false;
    }

    protected Locale currentLocale() {
        HttpSession session = this.pageContext.getSession();
        if (this.locale && session == null) {
            session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
        }
        if (session == null) {
            return null;
        }
        Locale current = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (current != null) {
            return current;
        }
        if (!this.locale) {
            return null;
        }
        current = this.pageContext.getRequest().getLocale();
        if (current != null) {
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)current);
        }
        return current;
    }
}

