/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.struts.taglib.logic.ConditionalTagBase;
import org.apache.struts.util.RequestUtils;

public class PresentTag
extends ConditionalTagBase {
    protected boolean condition() throws JspException {
        return this.condition(true);
    }

    protected boolean condition(boolean desired) throws JspException {
        boolean present = false;
        if (this.cookie != null) {
            Cookie[] cookies = ((HttpServletRequest)this.pageContext.getRequest()).getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            int i = 0;
            while (i < cookies.length) {
                if (this.cookie.equals(cookies[i].getName())) {
                    present = true;
                    break;
                }
                ++i;
            }
        } else if (this.header != null) {
            String value = ((HttpServletRequest)this.pageContext.getRequest()).getHeader(this.header);
            present = value != null;
        } else if (this.name != null) {
            Object value = null;
            try {
                value = RequestUtils.lookup(this.pageContext, this.name, this.property, this.scope);
            }
            catch (JspException e) {
                value = null;
            }
            present = value != null;
        } else if (this.parameter != null) {
            String value = this.pageContext.getRequest().getParameter(this.parameter);
            present = value != null;
        } else if (this.role != null) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            present = request.isUserInRole(this.role);
        } else if (this.user != null) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            Principal principal = request.getUserPrincipal();
            present = principal != null && this.user.equals(principal.getName());
        } else {
            JspException e = new JspException(ConditionalTagBase.messages.getMessage("logic.selector"));
            RequestUtils.saveException(this.pageContext, e);
            throw e;
        }
        return present == desired;
    }
}

