/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.xml.bind.DatatypeConverter;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.ClientUtil;
import org.jboss.naming.remote.client.RemoteContext;
import org.jboss.naming.remote.client.RemoteContextFactory;
import org.jboss.naming.remote.client.SecurityActions;
import org.jboss.naming.remote.client.cache.CacheShutdown;
import org.jboss.naming.remote.client.cache.ConnectionCache;
import org.jboss.naming.remote.client.cache.EndpointCache;
import org.jboss.naming.remote.protocol.IoFutureHelper;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    private static final Logger logger = Logger.getLogger(InitialContextFactory.class);
    public static final String ENDPOINT = "jboss.naming.client.endpoint";
    public static final String CONNECTION = "jboss.naming.client.connection";
    public static final String SETUP_EJB_CONTEXT = "jboss.naming.client.ejb.context";
    private static final String CLIENT_PROPS_FILE_NAME = "jboss-naming-client.properties";
    private static final long DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 5000L;
    private static final String CLIENT_PROP_KEY_ENDPOINT_NAME = "jboss.naming.client.endpoint.name";
    private static final String CLIENT_PROP_KEY_CONNECT_TIMEOUT = "jboss.naming.client.connect.timeout";
    private static final String ENDPOINT_CREATION_OPTIONS_PREFIX = "jboss.naming.client.endpoint.create.options.";
    private static final String CONNECT_OPTIONS_PREFIX = "jboss.naming.client.connect.options.";
    private static final String REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX = "jboss.naming.client.remote.connectionprovider.create.options.";
    public static final String CALLBACK_HANDLER_KEY = "jboss.naming.client.security.callback.handler.class";
    public static final String PASSWORD_BASE64_KEY = "jboss.naming.client.security.password.base64";
    public static final String REALM_KEY = "jboss.naming.client.security.realm";
    private static final OptionMap DEFAULT_ENDPOINT_CREATION_OPTIONS = OptionMap.create(Options.THREAD_DAEMON, true);
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.create(Options.SASL_POLICY_NOANONYMOUS, false);
    private static final OptionMap DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS = OptionMap.create(Options.SSL_ENABLED, false);
    private static final ConnectionCache connectionCache = new ConnectionCache();
    private static final EndpointCache endpointCache = new EndpointCache();
    private static final CacheShutdown cacheShutdown = new CacheShutdown(connectionCache, endpointCache);

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        try {
            ArrayList<RemoteContext.CloseTask> closeTasks = new ArrayList<RemoteContext.CloseTask>();
            Connection connection = this.getOrCreateConnection(env, this.findAndCreateClientProperties(env), closeTasks);
            IoFuture<Channel> futureChannel = connection.openChannel("naming", OptionMap.EMPTY);
            Channel channel = IoFutureHelper.get(futureChannel, 5000L, TimeUnit.MILLISECONDS);
            if (env.containsKey(SETUP_EJB_CONTEXT) && ((Boolean)env.get(SETUP_EJB_CONTEXT)).booleanValue()) {
                this.setupEjbContext(connection, closeTasks);
            }
            return RemoteContextFactory.createVersionedContext(channel, env, closeTasks);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw ClientUtil.namingException("Failed to create remoting connection", t);
        }
    }

    private Connection getOrCreateConnection(Hashtable<String, Object> env, Properties clientProperties, List<RemoteContext.CloseTask> closeTasks) throws IOException, NamingException, URISyntaxException {
        Connection connection = env.containsKey(CONNECTION) ? (Connection)env.get(CONNECTION) : this.createConnection(this.getOrCreateEndpoint(env, clientProperties, closeTasks), clientProperties, closeTasks);
        return connection;
    }

    private Connection createConnection(Endpoint clientEndpoint, Properties clientProperties, List<RemoteContext.CloseTask> closeTasks) throws IOException, URISyntaxException, NamingException {
        OptionMap connectOptionsFromConfiguration = this.getOptionMapFromProperties(clientProperties, CONNECT_OPTIONS_PREFIX);
        OptionMap connectOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_CREATION_OPTIONS, connectOptionsFromConfiguration);
        long connectionTimeout = 5000L;
        String connectionTimeoutValue = clientProperties.getProperty(CLIENT_PROP_KEY_CONNECT_TIMEOUT);
        if (connectionTimeoutValue != null && !connectionTimeoutValue.trim().isEmpty()) {
            try {
                connectionTimeout = Long.parseLong(connectionTimeoutValue.trim());
            }
            catch (NumberFormatException nfe) {
                logger.info("Incorrect timeout value " + connectionTimeoutValue + " specified. Falling back to default connection timeout value " + 5000L + " milli secondss");
            }
        }
        CallbackHandler callbackHandler = this.createCallbackHandler(clientProperties);
        String connectionUrl = clientProperties.getProperty("java.naming.provider.url");
        if (connectionUrl == null || connectionUrl.trim().isEmpty()) {
            throw new NamingException("No provider URL configured for connection");
        }
        URI connectionURI = new URI(connectionUrl);
        final Connection connection = connectionCache.get(clientEndpoint, connectionURI, connectOptions, callbackHandler, connectionTimeout);
        closeTasks.add(new RemoteContext.CloseTask(){

            @Override
            public void close(boolean isFinalize) {
                try {
                    if (isFinalize) {
                        connection.closeAsync();
                    } else {
                        connection.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to release connection", e);
                }
            }
        });
        return connection;
    }

    private Endpoint getOrCreateEndpoint(Hashtable<String, Object> env, Properties clientProperties, List<RemoteContext.CloseTask> closeTasks) throws IOException {
        Endpoint clientEndpoint = env.containsKey(ENDPOINT) ? (Endpoint)env.get(ENDPOINT) : this.createEndpoint(clientProperties, closeTasks);
        return clientEndpoint;
    }

    private Endpoint createEndpoint(Properties clientProperties, List<RemoteContext.CloseTask> closeTasks) throws IOException {
        String clientEndpointName = clientProperties.getProperty(CLIENT_PROP_KEY_ENDPOINT_NAME);
        if (clientEndpointName == null) {
            clientEndpointName = "config-based-naming-client-endpoint";
        }
        OptionMap endPointCreationOptionsFromConfiguration = this.getOptionMapFromProperties(clientProperties, ENDPOINT_CREATION_OPTIONS_PREFIX);
        OptionMap endPointCreationOptions = this.mergeWithDefaults(DEFAULT_ENDPOINT_CREATION_OPTIONS, endPointCreationOptionsFromConfiguration);
        OptionMap remoteConnectionProviderOptionsFromConfiguration = this.getOptionMapFromProperties(clientProperties, REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX);
        OptionMap remoteConnectionProviderOptions = this.mergeWithDefaults(DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS, remoteConnectionProviderOptionsFromConfiguration);
        final Endpoint clientEndpoint = endpointCache.get(clientEndpointName, endPointCreationOptions, remoteConnectionProviderOptions);
        closeTasks.add(new RemoteContext.CloseTask(){

            @Override
            public void close(boolean isFinalize) {
                try {
                    if (isFinalize) {
                        clientEndpoint.closeAsync();
                    } else {
                        clientEndpoint.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to release endpoint", e);
                }
            }
        });
        return clientEndpoint;
    }

    private CallbackHandler createCallbackHandler(Properties clientProperties) throws NamingException {
        String realm;
        String passwordBase64;
        String password;
        String userName;
        String callbackClass = clientProperties.getProperty(CALLBACK_HANDLER_KEY);
        CallbackHandler handler = this.resolveCallbackHandler(callbackClass, userName = clientProperties.getProperty("java.naming.security.principal"), password = clientProperties.getProperty("java.naming.security.credentials"), passwordBase64 = clientProperties.getProperty(PASSWORD_BASE64_KEY), realm = clientProperties.getProperty(REALM_KEY));
        if (handler != null) {
            return handler;
        }
        return new AnonymousCallbackHandler();
    }

    private CallbackHandler resolveCallbackHandler(String callbackClass, String userName, String password, String passwordBase64, String realm) throws NamingException {
        if (callbackClass != null && (userName != null || password != null)) {
            throw new RuntimeException("Cannot specify both a callback handler and a username/password for connection.");
        }
        if (callbackClass != null) {
            ClassLoader classLoader = InitialContextFactory.getClientClassLoader();
            try {
                Class<?> clazz = Class.forName(callbackClass, true, classLoader);
                return (CallbackHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load callback handler class " + callbackClass, e);
            }
            catch (Exception e) {
                throw ClientUtil.namingException("Could not instantiate handler instance of type " + callbackClass, e);
            }
        }
        if (userName != null) {
            String decodedPassword;
            if (password != null && passwordBase64 != null) {
                throw new NamingException("Cannot specify both a plain text and base64 encoded password");
            }
            if (passwordBase64 != null) {
                try {
                    decodedPassword = DatatypeConverter.printBase64Binary((byte[])passwordBase64.getBytes());
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Could not decode base64 encoded password for connection", e);
                }
            } else {
                decodedPassword = password != null ? password : null;
            }
            return new AuthenticationCallbackHandler(userName, decodedPassword == null ? null : decodedPassword.toCharArray(), realm);
        }
        return null;
    }

    private OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix) {
        ClassLoader classLoader = InitialContextFactory.getClientClassLoader();
        OptionMap.Builder optionMapBuilder = OptionMap.builder().parseAll(properties, propertyPrefix, classLoader);
        OptionMap optionMap = optionMapBuilder.getMap();
        logger.debug(propertyPrefix + " has the following options " + optionMap);
        return optionMap;
    }

    private OptionMap mergeWithDefaults(OptionMap defaults, OptionMap overrides) {
        OptionMap.Builder combinedOptionsBuilder = OptionMap.builder().addAll(overrides);
        for (Option<?> defaultOption : defaults) {
            if (combinedOptionsBuilder.getMap().contains(defaultOption)) continue;
            Object defaultValue = defaults.get(defaultOption);
            combinedOptionsBuilder.set(defaultOption, defaultValue);
        }
        OptionMap combinedOptions = combinedOptionsBuilder.getMap();
        if (logger.isTraceEnabled()) {
            logger.trace("Options " + overrides + " have been merged with defaults " + defaults + " to form " + combinedOptions);
        }
        return combinedOptions;
    }

    private static ClassLoader getClientClassLoader() {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return InitialContextFactory.class.getClassLoader();
    }

    private Properties findAndCreateClientProperties(Hashtable<?, ?> env) {
        Properties props = this.findClientProperties();
        if (props == null) {
            props = new Properties();
        }
        for (Map.Entry<?, ?> entry : env.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    private Properties findClientProperties() {
        ClassLoader classLoader = InitialContextFactory.getClientClassLoader();
        logger.debug("Looking for jboss-naming-client.properties using classloader " + classLoader);
        InputStream clientPropsInputStream = classLoader.getResourceAsStream(CLIENT_PROPS_FILE_NAME);
        if (clientPropsInputStream != null) {
            logger.debug("Found jboss-naming-client.properties using classloader " + classLoader);
            Properties clientProps = new Properties();
            try {
                clientProps.load(clientPropsInputStream);
                return clientProps;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load jboss-naming-client.properties", e);
            }
        }
        return null;
    }

    private void setupEjbContext(Connection connection, List<RemoteContext.CloseTask> closeTasks) {
        try {
            final ClassLoader classLoader = InitialContextFactory.class.getClassLoader();
            final Class<?> selectorClass = classLoader.loadClass("org.jboss.naming.remote.client.ejb.EjbClientContextSelector");
            Method setup = selectorClass.getMethod("setupSelector", Connection.class);
            final Object previous = setup.invoke(null, connection);
            closeTasks.add(new RemoteContext.CloseTask(){

                @Override
                public void close(boolean isFinalize) {
                    try {
                        Method reset = selectorClass.getMethod("resetSelector", classLoader.loadClass("org.jboss.ejb.client.ContextSelector"));
                        reset.invoke(null, previous);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to reset EJB remote context", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to setup EJB remote context", t);
        }
    }

    static {
        cacheShutdown.registerShutdownHandler();
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private final String realm;
        private final String username;
        private final char[] password;

        private AuthenticationCallbackHandler(String username, char[] password, String realm) {
            this.username = username;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    if (this.realm == null) {
                        String defaultText = rcb.getDefaultText();
                        rcb.setText(defaultText);
                        continue;
                    }
                    rcb.setText(this.realm);
                    continue;
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthenticationCallbackHandler that = (AuthenticationCallbackHandler)o;
            if (!Arrays.equals(this.password, that.password)) {
                return false;
            }
            if (this.realm != null ? !this.realm.equals(that.realm) : that.realm != null) {
                return false;
            }
            return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
        }

        public int hashCode() {
            int result = this.realm != null ? this.realm.hashCode() : 0;
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            result = 31 * result + (this.password != null ? Arrays.hashCode(this.password) : 0);
            return result;
        }
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName("$local");
                    continue;
                }
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

