package motoSample.client;

import java.util.Vector;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Hashtable;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;

import javax.naming.NamingException;

public final class LoginAction extends Action {

    // The constructor method for this class
    public LoginAction() {
    }

    // This sets the list as a session bean
    public ActionForward perform(ActionMapping mapping,
                                 ActionForm form,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
    throws IOException, ServletException {

        HttpSession session = request.getSession();
        LoginForm lform = (LoginForm )form;

        System.out.println("action forward..!!!");
        HelloClientBean clientbean = new HelloClientBean();
        clientbean.startup();
        session.setAttribute("greeting", clientbean.sayGreeting("Hello"));
        /*
        */

        if (lform.getAction().equals("post") && lform.getErrCnt() == 0) {
            UserLoginBean lib = new UserLoginBean();
            try {
                lib.startup();
                boolean res = lib.userLogin(lform.getUserId(), lform.getPwd());
                if (res) {
                    System.out.println("log in ok");
                }
                else {
                    System.out.println("log in failed");
                }
            }
            catch (NamingException e) {
                System.out.println("log in exception");
            }
        }
        
        return (mapping.findForward("logonok"));
    }
}
