package motoSample;

import java.io.Serializable;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.bean.ManagedProperty;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

import java.util.logging.Logger;
import javax.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.PreparedStatement;


import java.util.ArrayList;
import javax.faces.model.SelectItem;
import javax.faces.event.ValueChangeEvent;
import javax.annotation.PostConstruct;

import java.util.Date;
import java.text.SimpleDateFormat;


@ManagedBean
@ViewScoped
public class ChatBean implements Serializable {

    @Inject
    private Logger log;


    @Inject
    private FacesContext context;


    //inject user bean
    @ManagedProperty("#{userBean}")
    private UserBean userBean;
    
    private String msg;
    private String chatRoom;
    private int oldestChatId;
    private ArrayList<ChatMessage> msgList;
    
    public final static int LIST_LOAD_SIZE = 10;

    public void setMsg(String msg) {
        this.msg = msg;
    }
    public String getMsg() {
        return "";
    }
    public int getOldestChatId() {
        return oldestChatId;
    }
    public void setOldestChatId(int oldestChatId) {
        this.oldestChatId = oldestChatId;
    }

    public void setChatRoom(String chatRoom) {
        this.chatRoom = chatRoom;
    }
    public void chatRoomChanged(ValueChangeEvent e) {
        //chat room is changed. initialize the msg list.
        chatRoom = e.getNewValue().toString();
        log.info("chat room changed: " + this.chatRoom);
        initMsgList();
    }
    public String getChatRoom() {
        return chatRoom;
    }

    //userBean injection. setter only.
    public void setUserBean(UserBean userBean) {
        this.userBean = userBean;
    }

    ///chat list data
    public class ChatMessage {
        private String uname;
        private String msg;
        private String date;
        public String getUname() {
            return uname;
        }
        public String getMsg() {
            return msg;
        }
        public String getDate() {
            return date;
        }
    }

	private void initMsgList(){
        log.info("initMsgList: " + chatRoom);
        try {
            Connection conn = Resources.getConnection();
            String uid = userBean.getUid();
            String sqlString = "select user_id, message, msg_date, msg_id from tb_chat_msg where chat_room=\'" + chatRoom +"\' order by msg_id desc";

            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlString);
            
            if (msgList == null) {
                msgList = new ArrayList<ChatMessage>();
            }
            else {
                msgList.clear();
            }
            int load_cnt = 0;
            while (rs.next()) {
                ChatMessage m = new ChatMessage();
                m.uname = rs.getString("user_id");
                m.msg = rs.getString("message");
                m.date = rs.getString("msg_date");
                oldestChatId = rs.getInt("msg_id");
                msgList.add(0, m);
                if (++load_cnt == LIST_LOAD_SIZE)
                    break;
            }
            
            rs.close();
            conn.close();
        }
        catch (SQLException se) {
            log.severe("sql err!!!");
        }
	}
    
	public ArrayList<ChatMessage> getMsgList(){
        //log.info("getMsgList: " + chatRoom);
		return msgList;
	}
	    
    public void doPost() {
        //skip empty message....
        if (msg.equals(""))
            return;
        
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

        /*
        log.info("user = " + userBean.getUid());
        log.info("chat room = " + chatRoom);
        log.info("date = " + df.format(d));
        */

        try {
            Connection conn = Resources.getConnection();
            String sqlString = "insert into tb_chat_msg (user_id , chat_room , message , msg_date, deleted) values (?, ?, ?, ?, ?)";
            //log.info("sql = " + sqlString);
            
            PreparedStatement ps= conn.prepareStatement(sqlString); 
            ps.setString(1, userBean.getUid());
            ps.setString(2, chatRoom);
            ps.setString(3, msg);
            ps.setString(4, df.format(d));
            ps.setString(5, "false");

            int cnt = ps.executeUpdate();
            log.info(cnt + " records inserted.");

            conn.close();

            //add msgList...
            ChatMessage m = new ChatMessage();
            m.uname = userBean.getUid();
            m.msg = msg;
            m.date = df.format(d);
            msgList.add(m);
        }
        catch (SQLException se) {
            log.severe("sql err!!!");
        }
    
    }

    @PostConstruct
    public void postInit() {
        //log.info("PostConstruct userBean: " + userBean);
        //log.info("PostConstruct getFlights: " + userBean.getFlights());
        ArrayList<SelectItem> flights = userBean.getFlights();
        if (flights != null) {
            chatRoom = userBean.getFlights().get(0).getValue().toString();

            log.info("method: " + ((HttpServletRequest) context.getExternalContext().getRequest()).getMethod());
            if (((HttpServletRequest) context.getExternalContext().getRequest()).getMethod().equals("GET")) {
                log.info("get access. init chat list");
                //in get access, the chat room is not selected..
                initMsgList();
            }
        }
        
        //log.info("PostConstruct: " + chatRoom);
    }
}
