package motoSample;

import java.io.IOException;
import java.util.logging.Logger;


import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

 
/**
 * Filter checks if LoginBean has loginIn property set to true.
 * If it is not set then request is being redirected to the login.xhml page.
 * 
 * @author itcuties
 *
 */
public class LoginFilter implements Filter {
    Logger logger = Logger.getLogger(getClass().getName());
 
    /**
     * Checks if user is logged in. If not it redirects to the login.xhtml page.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {

        HttpSession session = ((HttpServletRequest)request).getSession();
        // Get the userBean from session attribute
        UserBean ubean = (UserBean)session.getAttribute("userBean");
        
        logger.info("cpath:" + ((HttpServletRequest) request).getContextPath());
        logger.info("uri:" + ((HttpServletRequest) request).getRequestURI());

        String req_url = ((HttpServletRequest) request).getRequestURI().replace(((HttpServletRequest) request).getContextPath(), "");
        logger.info("request_url:" + req_url);
        session.setAttribute("request_url", req_url);
        
        // For the first application request there is no userBean in the session so user needs to log in
        // For other requests userBean is present but we need to check if user has logged in successfully
        if (ubean == null || !ubean.isLoggedIn()) {
            String contextPath = ((HttpServletRequest)request).getContextPath();
            ((HttpServletResponse)response).sendRedirect(contextPath + "/login.jsf");
        }
         
        chain.doFilter(request, response);
             
    }
 
    public void init(FilterConfig config) throws ServletException {
        // Nothing to do here!
    }
 
    public void destroy() {
        // Nothing to do here!
    }   
     
}
