package motoSample;

import java.io.Serializable;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;

import java.util.logging.Logger;
import javax.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.ResultSet;
import java.sql.Statement;

import javax.servlet.http.HttpSession;

import java.util.ArrayList;
import javax.faces.model.SelectItem;

@ManagedBean
@SessionScoped
public class UserBean implements Serializable {

    @Inject
    private Logger log;

    private String uid;
    private String pwd;
    private String uname;
    
    private ArrayList<SelectItem> flights;
    
    private boolean login = false;

    public boolean isLoggedIn() {
        return login;
    }
    
    public String getUid() {
        return uid;
    }
    public String getPwd() {
        return pwd;
    }
    public String getUname() {
        return uname;
    }
    public void setUid(String uid) {
        this.uid = uid;
    }
    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
    
    public ArrayList<SelectItem> getFlights() {
        return flights;
    }
    
    private void initUserFlights(Connection conn) {
        if (flights == null) {
            flights = new ArrayList<SelectItem>();
        }
        flights.clear();
        
        try {
            String sqlString = "select flight_name from tb_user_flights where user_id=\'" + uid +"\'";
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlString);
            while(rs.next()) {
                String ft = rs.getString("flight_name");
                flights.add(new SelectItem(ft, ft));
            }
            statement.close();
        }
        catch (SQLException se) {
            log.severe("sql flight err!!!");
        }
    }
    
    public String doLogin() {

        try {
            Connection conn = Resources.getConnection();
            
            String sqlString = "select user_password, user_name from tb_users where user_id=\'" + uid +"\'";

            Statement statement = conn.createStatement();
            statement.setQueryTimeout(30);  // set timeout to 30 sec.

            ResultSet rs = statement.executeQuery(sqlString);
            if(rs.next())
            {
                // read the result set
                String db_pwd = rs.getString("user_password");
                //log.info("pwd = " + db_pwd);
                //log.info("name = " + rs.getString("user_name"));

                if (pwd.equals(db_pwd)) {
                    login = true;
                    this.uname = rs.getString("user_name");
                    statement.close();
                    
                    initUserFlights(conn);
                    
                    conn.close();
                    
                    HttpSession session = Resources.getSession();

                    ///after login, redirect to the user specified url.
                    return session.getAttribute("request_url").toString() + "?faces-redirect=true";
                }

            }
            else {
                log.info("uid " + uid + "not found...");
            }
            
            statement.close();
            conn.close();
        }
        catch (SQLException se) {
            log.severe("sql err!!!");
        }
        /*
        */
        
        return "";
    }
    
    public String doLogout() {
        login = false;
        return "/login.jsf";
    }
    
}
