; hello-is
; tab=4
CYLS EQU 10 ; 何シリンダまで読むか
	ORG	0x7c00		; このプログラムがどこに読み込まれるのか
; 以下は標準的なFAT12フォーマットフロッピーディスクのための記述
	JMP	entry
	DB      0x90
	DB	"HELLOIPL"	; ブートセクタの名前
	DW	512		; 1セクタの大きさ
	DB	1		; クラスタの大きさ
	DW	1		; FATがどこから始まるか
	DB	2		; FATの個数
	DW	224		; ルートディレクトリ領域の大きさ
	DW	2880		; このドライブの大きさ（2880セクタ）
	DB	0xf0		; メディアのタイプ
	DW	9		; FAT領域の長さ(9セクタ)
	DW	18		; 1トラックにいくつのセクタがあるか
	DW	2		; ヘッドの数
	DD	0		; パーティションを使っていないため0
	DD	2880		; このドライブの大きさをもう一度書く
	DB	0,0,0x29	;
	DD	0xffffffff	; たぶんボリュームシリアル番号
	DB	"HELLO-OS   "	; ディスクの名前(11バイト)
	DB	"FAT12   "	; フォーマットの名前(8バイト)
	RESB	18		; 18バイトあける
; プログラム本体
entry:
	MOV	AX, 0		; レジスタ初期化
	MOV	SS, AX
	MOV	SP, 0x7c00
	MOV	DS, AX
; ディスクを読む
	MOV	AX, 0x0820
	MOV	ES, AX
	MOV	CH, 0		; シリンダ0
	MOV	DH, 0		; ヘッド0
	MOV	CL, 2		; セクタ2
readloop:
	MOV	SI, 0		; 失敗回数を数えるレジスタ

retry:

	MOV	AH, 0x02	; AH=0x02 : ディスク読み込み
	MOV	AL, 1		; 1セクタ
	MOV	BX, 0
	MOV	DL, 0x00	; Aドライブ
	INT	0x13		; ディスクBIOS呼び出し
	JNC	next
	ADD	SI, 1
	CMP	SI, 5
	JAE	error
	MOV	AH, 0x00
	MOV	DL, 0x00	; Aドライブ
	INT	0x13		; ドライブのリセット
	JMP	retry
next:
	MOV	AX, ES		; アドレスを0x200進める。
	ADD	AX, 0x0020
	MOV	ES, AX
	ADD	CL, 1		; CLに1を足す
	CMP	CL, 18		; CLと18を比較
	JBE	readloop	; CL <= 18 だったらreadloopへ
	MOV	CL, 1
	ADD	DH, 1
	CMP	DH, 2
	JB	readloop	; DH < 2 だったらreadloopへ
	MOV	DH, 0
	ADD	CH, 1
	CMP	CH, CYLS
	JB	readloop	; CH < CYLS だったらreadloopへ
complete:
	MOV	SI, msg2
	JMP	0xc200		; haribote.sysの実行
error:
	MOV	SI, msg
	JMP	putloop
putloop:
	MOV	AL, [SI]
	ADD	SI, 1
	CMP	AL, 0
	JE	fin
	MOV	AH, 0x0e	; １文字表示ファンクション
	MOV	BX, 15		; カラーコード
	INT	0x10		; ビデオBIOS呼び出し	
	JMP	putloop
fin:
	HLT
	JMP	fin

; メッセージ部分
msg:
	DB	0x0a, 0x0a	;改行を2つ
	DB	"load error"
	DB	0x0a		;改行
	DB	0
msg2:
	DB	0x0a, 0x0a
	DB	"load complete"
	DB	0x0a
	DB	0

	RESB	0x7dfe-$		; 0x7dfeまでを0x00で埋める命令

	DB		0x55, 0xaa