/* 割り込み関係 */
#include "bootpack.h"

/**
 * @fn PICの初期化
 **/
void init_pic(void)
{
		io_out8(PIC0_IMR, 0xff); // すべての割り込みを受け付けない
		io_out8(PIC1_IMR, 0xff); // すべての割り込みを受け付けない
		
		io_out8(PIC0_ICW1, 0x11); //エッジトリガモード
		io_out8(PIC0_ICW2, 0x20); //IRC0-8は、INT20-27で受ける
		io_out8(PIC0_ICW3, 1 << 2); // PIC1はIRQ2にて接続
		io_out8(PIC0_ICW4, 0x01); //ノンバッファモード
		
		io_out8(PIC1_ICW1, 0x11); //エッジトリガモード
		io_out8(PIC1_ICW2, 0x28); // IRQ8-15は、INT28-2fで受ける
		io_out8(PIC1_ICW3, 2); // PIC1はIRQ2にて接続
		io_out8(PIC1_ICW4, 0x01); //ノンバッファモード
		
		io_out8(PIC0_IMR, 0xfb); // 11111011 PIC1以外はすべて禁止
		io_out8(PIC1_IMR, 0xff); //  11111111 すべての割り込みを受け付けない
		
		return;
}
/**
* @fn PS/2キーボードからの割り込み 
**/
void inthandler21(int *esp)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	boxfill8(binfo->vram, binfo->scrnx, COL8_BLACK, 0, 0, 32 * 8 - 1, 15);
	putfonts8_asc(binfo->vram, binfo->scrnx, 0, 0, COL8_WHITE, "INT 21 (IRQ-1) : PS/2 keyboard");
	for (;;) {
		io_hlt();
	}
}
/**
* @fn PS/2マウスからの割り込み
**/
void inthandler27(int *esp)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	boxfill8(binfo->vram, binfo->scrnx, COL8_WHITE, 0, 0, 32 * 8 - 1, 15);
	putfonts8_asc(binfo->vram, binfo->scrnx, 0, 0, COL8_WHITE, "INT 2C (IRQ-12) : PS/2 mouse");
	for (;;) {
		io_hlt();
	}
}
/**
* @fn PIC0からの不完全割り込み対策
* Athlon64X2機などではチップセットの都合によりPICの初期化時にこの割り込みがいちどだけ起こる
* この割り込み処理関数は、その割り込みに対して何もしないでやり過ごす。
* なぜ何もしなくてもいいかというとこの割り込みはPIC初期化時の電気的なノイズによって発生したものなので
* まじめに何か処理してやる必要がない。
**/
void inthandler2c(int *esp)
{
	io_out8(PIC0_OCW2, 0x67); //IRQ-07受付完了をPICに通知
	return;
}
