#define FLAGS_OVERRUN	0x0001

struct FIFO8 {
	unsigned char *buf;//バッファー
	int p;//書き込みの位置
	int q;//読み込みの位置
	int size;//バッファーのサイズ;
	int free;//空き容量
	int flags;//エラー状態など
};

/**
* @fn FIFOバッファの初期化
**/
void fifo8_init(struct FIFO8 *fifo, int size, unsigned char *buf);

/**
* @fn FIFOへデータを送り込んで蓄える
**/
int fifo8_put(struct FIFO8 *fifo, unsigned char data);

/**
* @fn FIFOからデータを1つ取ってくる
* @return バッファーが空のときは-1
**/
int fifo8_get(struct FIFO8 *fifo);

/**
* @fn どのくらいデータがたまっているか報告する
**/
int fifo8_status(struct FIFO8 *fifo);