﻿Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports ReversiGame

Imports System.Text

<TestClass()>
Public Class PointTest

    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(ByVal value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    ' テストを作成する際には、次の追加属性を使用できます:
    '
    ' クラス内で最初のテストを実行する前に、ClassInitialize を使用してコードを実行してください
    ' <ClassInitialize()> Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    ' End Sub
    '
    ' クラス内のテストをすべて実行したら、ClassCleanup を使用してコードを実行してください
    ' <ClassCleanup()> Public Shared Sub MyClassCleanup()
    ' End Sub
    '
    ' 各テストを実行する前に、TestInitialize を使用してコードを実行してください
    ' <TestInitialize()> Public Sub MyTestInitialize()
    ' End Sub
    '
    ' 各テストを実行した後に、TestCleanup を使用してコードを実行してください
    ' <TestCleanup()> Public Sub MyTestCleanup()
    ' End Sub
    '
#End Region

    <TestMethod()>
    Public Sub Construct()
        Dim point As New Point(2, 3)
        Assert.AreEqual(2, point.X)
        Assert.AreEqual(3, point.Y)
    End Sub

    <TestMethod()>
    Public Sub Construct2()
        Dim point As New Point(0, 0)
        Assert.AreEqual(0, point.X)
        Assert.AreEqual(0, point.Y)


    End Sub

    <TestMethod()>
    Public Sub ToStringTest()
        Dim point As New Point(0, 0)
        Assert.AreEqual("00", point.ToString)
        point.X = 1
        point.Y = 1
        Assert.AreEqual("a1", point.ToString)
        point.X = 8
        point.Y = 8
        Assert.AreEqual("h8", point.ToString)
        point.X = 9
        point.Y = 9
        Assert.AreEqual("99", point.ToString)
    End Sub


    '''<summary>
    '''op_Equality のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub op_EqualityTest()
        Assert.AreEqual(True, New Point("f5") = New Point("f5"))
        Assert.AreEqual(False, New Point("f4") = New Point("f5"))
    End Sub

    '''<summary>
    '''op_Inequality のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub op_InequalityTest()
        Assert.AreEqual(False, New Point("f5") <> New Point("f5"))
        Assert.AreEqual(True, New Point("f4") <> New Point("f5"))
    End Sub

    '''<summary>
    '''Point コンストラクター のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub PointConstructorTest()
        Dim p1 As Point = New Point("f5")
        Assert.AreEqual(6, p1.X)
        Assert.AreEqual(5, p1.Y)
        Dim p2 As Point = New Point("A6")
        Assert.AreEqual(1, p2.X)
        Assert.AreEqual(6, p2.Y)

    End Sub
End Class
