﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nft.framework;
using System.Globalization;
using System.Diagnostics;

namespace nft.test.test
{
    public class DateTimeTest
    {
        [TestEntry]
        public static bool CultureFormatTest()
        {
            CultureInfo current = CultureInfo.CurrentCulture;
            DumpCultureInfo(current);
            CultureInfo defcult = CultureInfo.GetCultureInfo("en-US");
            DumpCultureInfo(defcult);
            return true;
        }

        private static void DumpCultureInfo(CultureInfo info){
            Debug.WriteLine("CultureName= " + info.DisplayName);
            Debug.Write("DayNames= "); 
            foreach(string s in info.DateTimeFormat.DayNames)
                Debug.Write("  " + s);
            Debug.WriteLine("");
            Debug.Write("AbbreviatedDayNames= ");
            foreach (string s in info.DateTimeFormat.AbbreviatedDayNames)
                Debug.Write("  " + s);
            Debug.WriteLine("");
            Debug.Write("MonthNames= ");
            foreach (string s in info.DateTimeFormat.MonthNames)
                Debug.Write("  " + s);
            Debug.WriteLine("");
            Debug.Write("AbbreviatedMonthNames= ");
            foreach (string s in info.DateTimeFormat.AbbreviatedMonthNames)
                Debug.Write("  " + s);
            Debug.WriteLine("");
        }
    }
}
