﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nft.framework;
using System.Xml;
using nft.util;
using nft.framework.loader;
using System.Diagnostics;

namespace nft.test.test
{
    class ParamsReaderTest
    {
        static readonly string xmlPath = @"system\plugin.xml";
        static XmlDocument doc;

        static ParamsReaderTest() {
            string path = Directories.PluginDir + xmlPath;
            doc = XmlUtil.LoadFile(path);
        }

        [TestEntry]
        static private void TestXmlParser(){
            XmlParamParser parser = new XmlParamParser(doc);
            ParamsReader reader = new ParamsReader(doc.BaseURI, parser);
            ParamsReader r2 = reader["plug-in"];
            Debug.WriteLine("title = " + r2["title"].InnerText);
            foreach (ParamsReader r3 in r2.EnumChildren("contribution")) {
                Debug.Write("name = " + r3["name"].InnerText);
                Debug.WriteLine(", ID = " + r3["id"].InnerText);
                Debug.WriteLine("impl or class = " + r3["class|implementation"]["name"].InnerText);
                ParamsReader r4 = r3["command"];
                if (!r4.IsNull) {
                    Debug.WriteLine("command = " + r4["menupath"].InnerText);
                }
            }
            IFileSource fs = reader.GetFileSource("test.txt");
            Debug.WriteLine("file=" + (fs != null ? fs.Uri : "null"));
            fs = reader.GetFileSource("work/test2.txt");
            Debug.WriteLine("file2=" + (fs != null ? fs.Uri : "null"));
            fs = reader.GetFileSource(@"/work/test3.txt");
            Debug.WriteLine("file3=" + (fs != null ? fs.Uri : "null"));
            fs = reader.GetFileSource(@"work\test4.txt");
            Debug.WriteLine("file4=" + (fs != null ? fs.Uri : "null"));
            fs = reader.GetFileSource(@"\work\test5.txt");
            Debug.WriteLine("file5=" + (fs != null ? fs.Uri : "null"));
        }

    }
}
