using System;
using System.Collections;
using System.Diagnostics;
using nft.core;
using nft.core.geometry;
using nft.framework;

namespace nft.debug
{
	/// <summary>
    /// TestGeometric ̊Tv̐łB
	/// </summary>
	public class TestGeometric
	{
        [TestEntry]
        public static void TestDirection()
		{
			Array da = Enum.GetValues(typeof(Direction16));
			Debug.WriteLine("--test1--");
			foreach(Direction16 d in da)
			{
				Direction dir = Direction.Get(d);
				Debug.Write(string.Format("{0}:c={1},ic={2},mj={3},",dir.LocalizedName,dir.IsCardinal,dir.IsInterCardinal,dir.IsMajor));
				Debug.WriteLine(string.Format("opposite={0},left={1},left_q={2},right={3},right_q={4}",dir.Opposite.LocalizedName,dir.Left.LocalizedName,dir.LeftQuater.LocalizedName,dir.Right.LocalizedName,dir.RightQuater.LocalizedName));
			}
			Debug.WriteLine("--test2--");
			for(int i=0; i<da.Length; i++)
			{
				for(int j=0; j<da.Length; j++)
				{
					Direction d1 = (Direction16)da.GetValue(i);
					Direction d2 = (Direction16)da.GetValue(j);
					Debug.Write(string.Format("{0}<->{1}:",d1.LocalizedName,d2.LocalizedName));
					Debug.WriteIf(d1==d2,"==,");
					Debug.WriteIf(d1.Equals(d2),"Equals,");
					Debug.WriteIf(d1.IsParallel(d2),"Parallel,");
					Debug.WriteIf(d1.IsOpposite(d2),"Opposite,");
					Debug.WriteIf(d1.IsPerpendiculerTo(d2),"RightAngle,");
					Debug.WriteLine(string.Format("Angle={0}", Direction.AngleStepCount(d1,d2)));
				}
			}
		
			// cast test
			Direction direction;
			direction = Direction4.EAST;
			direction = Direction8.NORTHEAST;
			direction = Direction16.NORTHNORTHWEST;
			//Direction4 d4 = direction; // compile error
			//Direction8 d8 = direction; // compile error
			Direction16 d16 = direction;		
		}

        [TestEntry]
        public static void TestLocation() {
            Show(new Location(1, 2, 3), new Location(3, 2, 1));
            Show(new Location(2, 3, 1), new Location(3, 2, 1));
            Show(new LocationF(1, 1, 3), new LocationF(2, 4, 3));
            Show(new LocationF(4, 2, 1), new LocationF(1, 1, 3));
        }

        private static void Show(Location l1, Location l2) {
            Debug.WriteLine(string.Format("from {0} to {1}", l1, l2));
            Debug.WriteLine(string.Format("dir={0}, distance={1}", l1.GetDirectionTo(l2), l1.GetDistanceTo(l2)));
        }

        private static void Show(LocationF l1, LocationF l2) {
            Debug.WriteLine(string.Format("from {0} to {1}", l1, l2));
            Debug.WriteLine(string.Format("dir={0}, distance={1}", l1.GetDirectionTo(l2), l1.GetDistanceTo(l2)));
        }
	}
}
