﻿using nft.framework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nft.core
{
    public class VWorldId : VAbstractIdentifier
    {
        public static readonly string PREFIX = "World:";

        internal static VWorldId Generate()
        {
            return new VWorldId(PREFIX + DateTime.Now.Ticks);
        }

        private VWorldId(string idStr) : base(idStr) {}

        public string ShortID
        {
            get
            {
                long tick = long.Parse(this.AsString.Substring(PREFIX.Length));
                return $"{tick:X}";
            }
        }
    }
}
