using System;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.Serialization;
using System.Collections.Generic;
using nft.framework;

namespace nft.core.geometry {
    /// <summary>
    /// 16 directions (Int16).
    /// </summary>
    public enum Direction16 : short {
        NORTH, WEST, SOUTH, EAST,
        NORTHEAST, NORTHWEST, SOUTHWEST, SOUTHEAST,
        NORTHNORTHEAST, NORTHNORTHWEST, WESTNORTHWEST, WESTSOUTHWEST,
        SOUTHSOUTHWEST, SOUTHSOUTHEAST, EASTSOUTHEAST, EASTNORTHEAST,
        //INVALID = byte.MaxValue
    }

    /// <summary>
    /// 8 directions (Int16).
    /// Cardinal and inter-cardinal directions.
    /// </summary>
    public enum Direction8 : short {
        NORTH, WEST, SOUTH, EAST,
        NORTHEAST, NORTHWEST, SOUTHWEST, SOUTHEAST,
        //INVALID = short.MaxValue
    }

    /// <summary>
    /// 4 cardinal directions (Int16).
    /// </summary>
    [Serializable]
    public enum Direction4 : short {
        NORTH, WEST, SOUTH, EAST,
        //INVALID = byte.MaxValue
    }

    /// <summary>
    /// 4 inter cardinal directions (Int16).
    /// </summary>
    [Serializable]
    public enum InterCardinalDirection : short {
        // 4̔{Ŏn܂Alł邱(O̎)
        NORTHEAST = 4, NORTHWEST, SOUTHWEST, SOUTHEAST,
        //INVALID = byte.MaxValue
    }
}
