﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework.drawing;
using nft.core.view;
using nft.contributions.graphics;
using nft.core.structure;
using nft.core.geometry;
using nft.core.graphics;
using System.Drawing;

namespace nft.core.graphics {
    public interface IStructureSkin {
        ITexture this[ISceneParams p, InterCardinalDirection upperDir] {
            get;
        }

        CtbStructureSkin Contribution {
            get;
        }

        ISiteDefiner SiteDefiner {
            get;
        }
    }

    public class StructureSkin : IStructureSkin {
        private CtbStructureSkin contrib;
        private InterCardinalDirection rotationOffset;

        public StructureSkin(CtbStructureSkin ctb, InterCardinalDirection rotation_offset) {
            this.contrib = ctb;
            this.rotationOffset = rotation_offset;
        }

        public CtbStructureSkin Contribution {
            get {
                return contrib;
            }
        }

        public virtual ITexture this[ISceneParams p, InterCardinalDirection upperDir] {
            get {
                int rot_idx = (int)upperDir - (int)rotationOffset;
                TextureSrc src = Contribution.TextureSet[rot_idx][p];
                GraphicManagerEx gm = GraphicManagerEx.GraphicManager;
                ResourceKey key = ResourceKey.CreateKey(Contribution, (ushort)rot_idx);
                ITexture tex = gm.CreateStaticTexture(key, src.ImageResource.Data[p].ImageSrc, src.Region);
                return tex;
            }
        }

        public ISiteDefiner SiteDefiner {
            get {
                return Contribution.SiteDefiner;
            }
        }

    }
}
