﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.core.math {
    public class Matrix2D { 
        private double[,] data;

        public Matrix2D(int cols, int rows) {
            data = new double[cols, rows];
            data.Initialize();
        }

        public Matrix2D(decimal[,] src) {
            int cs = src.GetLength(0);
            int rs = src.GetLength(1);
            data = new double[cs,rs];
            for (int c = 0; c < cs; c++) {
                for (int r = 0; r < rs; r++) {
                    data[c, r] = (double)src[c, r];
                }
            }
        }


        public double this[int col,int row]{
            get {
                return data[col, row];
            }
            set {
                data[col, row] = value;
            }
        }
    }
}
