﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.core.schedule {
    public interface ITimeTickConverter {
        /// <summary>
        /// 閏年を扱うか。falseの場合毎年の日数は固定。
        /// If false, every year has the same count of days.
        /// (YearlyTicksAve/DailyTicks equals to the count of days.)
        /// </summary>
        bool TreatLeapYears { get; }
        
        /// <summary>
        /// 月毎の日数は可変か。falseの場合毎月の日数は固定。
        /// Every month has the same count of days.
        /// It's calculated by MonthlyTicksAve/DailyTicks.
        /// </summary>
        bool DaysInMonthVariable { get; }

        Date ToDate(long ticks);
        TimeOfDay ToTimeOfDay(long ticks);
        long ToTicks(Date d);
        long ToTicks(TimeOfDay td);

        int GetSecond(long ticks);
        int GetMinute(long ticks);
        int GetHour(long ticks);
        int GetDay(long ticks);
        int GetDayOfWeek(long ticks);
        int GetMonth(long ticks);
        int GetYear(long ticks);

        int GetDayOfWeek(Date d);

        long DailyTicks { get; }
        long HourlyTicks { get; }
        long MinutelyTicks { get; }

        // average ticks in a month.
        long MonthlyTicksAve { get; }
        // average ticks in a year.
        long YearlyTicksAve { get; }

        long TicksForUnit(TimeUnit cycle);
    }
}
