﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.core.structure {
    public class CatalogVarNameConstants {
        /// <summary>
        /// カラーバリエーション
        /// Index of the color variations of the structure.
        /// An option for color variable sprite skins.
        /// </summary>
        public static readonly string Color = "color";

        /// <summary>
        /// デザインバリエーション
        /// Index of the outlook design variations of the structure.
        /// Complete replacement of the skin sprite.
        /// Sub category of the same named stractures?
        /// </summary>
        public static readonly string Design = "design";

        /// <summary>
        /// 方向による回転パターン
        /// Index of the rotated patterns of the structure.
        /// The most primitive variable for structures.
        /// </summary>
        public static readonly string Direction = "direction";

        /// <summary>
        /// 高さ可変ビルの高さ
        /// Variable for the height parameter of the structure.
        /// An option for height variable tall buildings.
        /// </summary>
        public static readonly string Height = "height";

        /// <summary>
        /// 敷地面積可変ビルの広さ
        /// Index of the lot size variations of the structure.
        /// An option for size variable extendable buildings.
        /// </summary>
        public static readonly string LotSize = "lot_size";

    }
}
