﻿using System;
using nft.core.geometry;
using System.Drawing;
using System.Diagnostics;
using nft.ui;

namespace nft.impl.view {
    public class ViewController : IDisposable {

        SceneBuilder builder;
        bool prepared;
        IView view;

        public ViewController(SceneBuilder builder, IView view) {
            prepared = false;
            this.builder = builder;
            this.view = view;
            view.SurfacePrepared += SurfaceReady;
            view.ViewPointChanged += ViewPointChanged;
            //SetScrollParams();
        }

        private void SetScrollParams() {
            //Size szu = new Size(Geocon.UnitWidthPixel, Geocon.HalfOf_UnitWidthPixel);
            Size szc = builder.ContentSize;
            view.SetScrollParams(szc);
        }

        void ViewPointChanged(ViewPointEventArgs ea)
        {
            Point pt = ea.Position;
            Debug.WriteLine(", vwps=" + pt);
            builder.ViewPosition = pt;
        }                   

        public SceneBuilder SceneBuilder {
            get { return builder; }
        }


        public IView View {
            get { return view; }
        }

        public InterCardinalDirection UpperDirection {
            get { return builder.UpperDirection; }
            set {
                builder.UpperDirection = value;
                view.Refresh();
            }
        }

        void SurfaceReady(object sender, EventArgs e) {
            builder.AttachSurface(view.Surface);
            SetScrollParams();
            prepared = true;
        }

        #region IDisposable 定型
        public virtual void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(Boolean disposing)
        {
            if (disposing ) {
                if (view != null) {
                    view.Close();
                    view = null;
                }
                builder = null;
            }
            prepared = false;
        }

        public bool IsDisposed { get { return view == null; } }

        ~ViewController()
        {
            Dispose(false);
        }
        #endregion
    }
}
