﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using nft.core.geometry;
using System.Drawing;
using nft.framework.drawing;
using nft.core.game;
using nft.impl.game;
using ITerrainPiece = nft.core.geometry.ITerrainPiece;

namespace nft.impl.view_old
{
    public class TerrainPolygonExporter
    {
        internal static void ExportPolygons(MapViewDrawer drawer)
        {
            SaveFileDialog saveFileDlg = new SaveFileDialog();
            saveFileDlg.DefaultExt = "csv";
            saveFileDlg.Filter = "CSVﾌｧｲﾙ|*.csv|全てのファイル|*.*";
            saveFileDlg.ShowDialog();
            string fname = saveFileDlg.FileName;
            if (fname != null && fname.Length > 0)
            {                
                StreamWriter writer = new StreamWriter(fname, false, Encoding.GetEncoding("shift-jis"));
            }
        }

        private static void ExportCore(StreamWriter writer, MapViewDrawer drawer)
        {
            writer.WriteLine("type,p1.X,p1.Y,p1.Z,p2.X,p2.Y,p2.Z,p3.X,p3.Y,p3.Z");
            TerrainMapImpl map = drawer.TerrainMap as TerrainMapImpl;
            Size3D sz3 = map.Size;
            InterCardinalDirection upperDir = drawer.ViewFactor.ViewDirection;
            CoordinationUtil cdutil = drawer.CdUtil;
            for (int y = 0; y < sz3.sy; y++)
            {
                for (int x = 0; x < sz3.sx; x++)
                {
                    foreach (ITerrainPiece tp in map[x, y, upperDir])
                    {
                        TerrainPieceTemplate.TerrainPolygonSet tpset = tp.Template.GetPolygons(upperDir);
                        if(tpset.Ground.IsVisible){
                            foreach (InterCardinalDirection d in Enum.GetValues(typeof(InterCardinalDirection)))
                            {
                                int h = tp.GetOffsetHeightAt(d);
                                if(h<0) continue;
                                int h0 = tp.BaseHeight;
                                WritePoint(writer, x, y, sz3.sy + h0);
                            }
                            writer.WriteLine();
                        }
                    }
                }
            }
            writer.Flush();
            writer.Close();            
        }

        private static void WritePoint(StreamWriter writer, int X, int Y, int Z_height)
        {
            writer.Write(X);
            writer.Write(',');
            writer.Write(Z_height);
            writer.Write(',');
            writer.Write(Y);
            writer.Write(',');
        }

    }
}
