﻿
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using nft.framework;
using nft.framework.plugin;
using System.Diagnostics;
using nft.ui.command;
using System.IO;
using nft.ui.mainframe;

namespace nft.debug {
    public partial class CacheDirManageForm : Form {
        public CacheDirManageForm() {
            InitializeComponent();
            string path = Directories.DataDir;
            tbCachePath.Text = path;
            labelDiskSize.Text = ToByteSizeText(Directories.GetDirectorySize(path));
        }

        private string[] size_units = { "B", "kB", "MB", "TB" };
        private string ToByteSizeText(long s) {
            int i = 0;
            while (s > 1000) {
                i++;
                s /= 1000;
            }
            return s.ToString() + size_units[i];
        }

        private void btnExplorer_Click(object sender, EventArgs e) {
            Process.Start("explorer.exe", "/e," + Directories.DataDir);
        }

        private void btnClear_Click(object sender, EventArgs e) {
            Main.Exit(DeleteCacheDir, null);
        }

        void DeleteCacheDir(object arg) {
            Directory.Delete(Directories.DataDir, true);
        }

        private void btnCancel_Click(object sender, EventArgs e) {
            this.Close();
        }
    }
}
