using System;
using System.Drawing;
using System.Collections.Generic;

namespace nft.framework.drawing
{
    public enum SurfaceUsage { Normal, PreCombinedTexture, GameView };

    public interface ISurface : IDisposable
    {
        IEnumerable<I3DObject> Objects { get; set; }
        IEffectFilter Effect { get; set; }
        Size Size { get; }
        void Draw();
        long GameTicks { get; set; }
        Color FillColor { get; set; }
        bool ClearEveryDraw { get; set; }
        //public Bitmap ToBitmap();

        /// <summary>
        /// 3D world location corresponds to bottom center of the viewport.
        /// </summary>
        PointF3D CameraPosition { get; set; }
        
        /// <summary>
        /// Convert view 2D position into 3D world location
        /// </summary>
        /// <param name="screenpos"></param>
        /// <returns></returns>
        PointF3D ToWorldPosition(Point screenpos);

        /// <summary>
        /// Convert 3D world location into view 2D position
        /// </summary>
        /// <param name="screenpos"></param>
        /// <returns></returns>
        Point ToScreenPosition(PointF3D worldpos);

        /// <summary>
        /// Returns ID of which drawn on the specific pixel.
        /// </summary>
        /// <param name="vx"></param>
        /// <param name="vy"></param>
        /// <returns></returns>
        UInt32 HitTestAt(int vx, int vy);
    }
    
    /// <summary>
	/// ISurface IDrawable`悷LpX
	/// </summary>
	public interface ISurfaceOld : IDrawable
	{
		PixelColorMode PixelColorMode {get;}
		Color ColorKey { get; set; }
		Size Size { get; }
		/// <summary>
		/// Clear the surface region with a specified color.
		/// </summary>
		/// <param name="region"></param>
		/// <param name="fill"></param>
		void Clear(Rectangle region, Color fill);
		void Clear(Color fill);
        void BitBlt(ISurfaceOld source, DrawParams dp);
        void BitBlt(ISurfaceOld source, DrawParams dp, IPixelFilter filter);
        void BitBlt(ISurfaceOld source, DrawParams dp, ISurfaceDrawer drawer);
		bool HitTest(int x, int y );
		Bitmap CreateBitmap(PixelColorMode mode);
        bool IsSurfaceLost { get; }
	}

}
