﻿using System;
using System.Collections.Generic;
      
 

using System.Text;
using System.Drawing;

namespace nft.framework.drawing {
    public class RectUtil {

        /// <summary>
        /// returns smallest rectangle which contains all points given as argument
        /// </summary>
        /// <param name="pts"></param>
        /// <returns></returns>
        public static Rectangle GetBounds(Point[] pts) {
            if (pts == null || pts.Length == 0)
                return Rectangle.Empty;
            int xmax, xmin, ymax, ymin;
            xmax = xmin = pts[0].X;
            ymax = ymin = pts[0].Y;
            for (int i = 1; i < pts.Length; i++) {
                int px = pts[i].X;
                int py = pts[i].Y;
                xmax = Math.Max(xmax, px);
                xmin = Math.Min(xmin, px);
                ymax = Math.Max(ymax, py);
                ymin = Math.Min(ymin, py);
            }
            return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        }

        /// <summary>
        /// returns maximum rectangle which included in the rescaled soruce rectangle.
        /// </summary>
        /// <param name="src">soruce rectangle</param>
        /// <param name="divHorz">horizontal division value</param>
        /// <param name="divVirt">virtical division value</param>
        /// <returns></returns>
        public static Rectangle DivideInscribe(Rectangle src, double divHorz, double divVirt) {
            int x = (int)Math.Ceiling(src.X / divHorz);
            int y = (int)Math.Ceiling(src.Y / divVirt);
            int x2 = (int)Math.Floor(src.Right / divHorz);
            int y2 = (int)Math.Floor(src.Bottom / divVirt);
            return new Rectangle(x, y, x2 - x, y2 - y);
        }
        /// <summary>
        /// returns minimum rectangle which wraps in the rescaled soruce rectangle.
        /// </summary>
        /// <param name="src">soruce rectangle</param>
        /// <param name="divHorz">horizontal division value</param>
        /// <param name="divVirt">virtical division value</param>
        /// <returns></returns>
        public static Rectangle DivideCircumscribe(Rectangle src, double divHorz, double divVirt) {
            int x = (int)Math.Floor(src.X / divHorz);
            int y = (int)Math.Floor(src.Y / divVirt);
            int x2 = (int)Math.Ceiling(src.Right / divHorz);
            int y2 = (int)Math.Ceiling(src.Bottom / divVirt);
            return new Rectangle(x, y, x2 - x, y2 - y);
        }
        /// <summary>
        /// returns maximum integer rectangle which included in the soruce RectangleF.
        /// </summary>
        /// <param name="src"></param>
        /// <returns></returns>
        public static Rectangle GetInscribed(RectangleF src) {
            int x = (int)Math.Ceiling(src.X);
            int y = (int)Math.Ceiling(src.Y);
            int x2 = (int)Math.Floor(src.Right);
            int y2 = (int)Math.Floor(src.Bottom);
            return new Rectangle(x, y, x2 - x, y2 - y);
        }
        /// <summary>
        /// returns minimum integer rectangle which wraps in the soruce RectangleF.
        /// </summary>
        /// <param name="src"></param>
        /// <returns></returns>
        public static Rectangle GetCircumscribed(RectangleF src) {
            int x = (int)Math.Floor(src.X);
            int y = (int)Math.Floor(src.Y);
            int x2 = (int)Math.Ceiling(src.Right);
            int y2 = (int)Math.Ceiling(src.Bottom);
            return new Rectangle(x, y, x2 - x, y2 - y);
        }

    }
}
