using System;
using System.Xml;
using nft.framework.plugin;
using System.Diagnostics;

namespace nft.framework.plugin
{
    public class DummyContributionFactory : Contribution, IContributionFactory {
        public DummyContributionFactory(Plugin p, ParamsReader contrib)
            : base(p, contrib) {
        }

        #region IContributionFactory o
        public Type OutputType {
            get {
                return typeof(DummyContribution);
            }
        }

        public Contribution load(Plugin owner, ParamsReader e) {
            return new DummyContribution(owner, e);
        }
        #endregion
    }

    /// <summary>
	/// commercial structure.
	/// 
	/// Including everything from convenience stores (like Seven-eleven)
	/// to shopping malls like Walmart.
	/// </summary>
	[Serializable]
	public class DummyContribution : Contribution
	{
		/// <summary>
		/// Dummy Contribution for Debug
		/// </summary>
		/// <exception cref="XmlException">If the parsing fails</exception>
        public DummyContribution(Plugin p, ParamsReader e) : base(p, e) { }

		// TODO: additional parameters, like population and attractiveness.
	}
}
