using System;
using System.Xml;
using System.IO;

namespace nft.framework.plugin
{
	/// <summary>
	/// XmlFormatExceptionClass1 ̊Tv̐łB
	/// </summary>
	public class PluginXmlException : Exception
	{
        protected ParamsReader node;
		protected Plugin plugin = null;
		protected Contribution contrib = null;

        public PluginXmlException(ParamsReader node, string msg)
			:base(msg)
		{
			this.node = node;
		}

		public PluginXmlException(Plugin p, ParamsReader node, string msg)
			:this(node,msg)
		{
			this.plugin = p;
		}

        public PluginXmlException(Contribution c, ParamsReader node, string msg)
			:this(node,msg)
		{
            AttachContribution(c);
		}

        public void AttachContribution(Contribution c){
            this.contrib = c;
            this.plugin = c.Parent;
        }

        private bool ConfirmPlugin()
		{
            if (plugin != null) return true;
			
			plugin = PluginManager.theInstance.GetPlugin(new VPluginId(new Uri(node.SourceURI)));
            return plugin != null;
		}

		public string getDetailedMessage(string linecode)
		{
			string msg = base.Message;
            if (!ConfirmPlugin())
			{
				msg+=string.Format(" Plug-In:{0}","N/A");
				return msg;
			}
			msg+=string.Format(" Plug-In:{0}{1}",plugin.ID,linecode);
			msg+=string.Format(" Title:{0}{1}",plugin.Title,linecode);
			msg+=string.Format(" Author:{0}",plugin.author);
			if(contrib!=null)
			{
				msg+=string.Format(" {0}Contrib-ID:{1}",linecode,contrib.ID);
				msg+=string.Format(" {0}Name:{1}",linecode,contrib.Name);
			}
			return msg;
		}

        public ParamsReader ParamsReader { get { return node; } }
	}
}
