﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using nft.util;
using nft.ui.mainframe_old;
using nft.framework;
using System.Xml;
using System.Diagnostics;

namespace nft.ui.command {
    public class CommandPathHint {
        protected string id;
        protected string parent;
        protected string before;
        protected string after;

        public CommandPathHint(ParamsReader e) {
            this.ID = e["id"].InnerText;
            this.Parent = e["parent"].InnerText;
            this.Before = e["before"].InnerText;
            this.After = e["after"].InnerText;
        }

        public CommandPathHint(string id) {
            this.ID = id;
        }

        [Obsolete]
        public CommandPathHint(string id, string after, string before) {
            this.ID = id;
            this.After = after;
            this.Before = before;
        }

        #region getter and setter
        public string ID {
            get { return id; }
            set {
                if (value != null && value.Length == 0) {
                    id = null;
                } else {
                    id = value;
                }
            }
        }

        /// <summary>
        /// use "" to point out root node.
        /// null value will be replaced by "".
        /// </summary>
        public string Parent{
            get { return parent; }
            set {
                if (value == null) {
                    parent = "";
                } else {
                    parent = value;
                }
            }
        }

        public string Before{
            get { return before; }
            set {
                if (value != null && value.Length == 0) {
                    before = null;
                } else {
                    before = value;
                }
            }
        }

        public string After{
            get { return after; }
            set {
                if (value != null && value.Length == 0) {
                    after = null;
                } else {
                    after = value;
                }
            }
        }

        public string GroupName {
            get { return CommandPathHint.SplitGroupName(this.id); }
        }

        /// <summary>
        /// split groupname prefix from item ID
        /// </summary>
        /// <param name="iid"></param>
        /// <returns></returns>
        public static string SplitGroupName(string iid) {
            int n = iid.IndexOf(CommandPathHelper.GroupSepalator);
            if (n == -1)
                return "";
            else
                return iid.Substring(0, n);
        }
        #endregion
    }

 
}
