using System;
using System.Windows.Forms;
using nft.framework;

namespace nft.ui.command
{
	/// <summary>
	/// 
	/// </summary>
	public class ModelessFormCommand : ITriggerCommandProcedure
	{
		readonly Type formClass;

		public ModelessFormCommand(Type FormClass)
		{
			formClass = FormClass;
		}

        public bool Enable {
            get { return true; }
        }

        public event EventHandler EnableChanged;

        public void Execute() {
            Form f = Activator.CreateInstance(formClass) as Form;
            f.Show();
        }
    }
}
