﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using nft.core.game;
using nft.core.view;
using nft.impl.view;
using nft.framework.drawing;
using nft.impl.game;
using Geocon = nft.core.geometry.GeometricConstants;
using nft.core.geometry;

namespace nft.ui.core
{
    public partial class InspectorTool : UserControl, IPointerHandler
    {
        public InspectorTool()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            GameManager.theInstance.Tools.Add(this, false);
        }

        #region IPointerHandler implementation
        protected IGame game;
        public void OnAttach(IGame g)
        {
            this.game = g;
        }

        public void OnDetach(IGame g)
        {
            this.game = null;
        }

        public void OnMouseButtonDown(PointerEventArgs args)
        {
        }

        public void OnMouseButtonUp(PointerEventArgs args)
        {
        }

        public void OnMouseMove(PointerEventArgs args)
        {
            ViewController view = args.Game.Views.ActiveView;
            Point pos = args.OriginalEventArgs.Location;
            SelectionInfo si = view.SceneBuilder.GetObjectAt(pos);
            if (si != null) {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine(String.Format("Location({0},{1}), Height={2}", si.Location.X, si.Location.Y, si.Location.Z));
                //sb.AppendLine(String.Format("ViewGrid({0:f1},{1:f1},{2:f1})", si.WorldPosition.X / Geocon.UnitWidthPixel, si.WorldPosition.Z / Geocon.UnitWidthPixel, si.WorldPosition.Y / Geocon.UnitHeightPixel));
                sb.Append(String.Format("HT={0:X6}", si.HitTestValue));
                if (si.TerrainPiece != null) {
                    sb.Append(String.Format(",TID={0:X6}", si.TerrainPiece.Template.ID));
                    if (si.Polygon != null) {
                        sb.AppendLine(String.Format(",PID={0:X6}", si.Polygon.ID));
                    } else {
                        sb.AppendLine();
                    }
                } else {
                    sb.AppendLine(",NoTerrain");
                }
                lbStatus.Text = sb.ToString();
                this.renderViewPanel.Surface.Objects = ToRenderObjects(si);
            } else {
                lbStatus.Text = "N/A";
            }
        }

        protected IEnumerable<I3DObject> ToRenderObjects(SelectionInfo si) {
            if (si.TerrainPiece != null) {
                Point3DV pv = (Point3DV)si.WorldPosition;
                IEnumerable<I3DObject> terrains = si.SceneBuilder.GetTerrainsAt(si.Location);
                int h = si.TerrainPiece.BaseHeight * Geocon.UnitHeightPixel;
                PointF3D pt;
                foreach (I3DObject obj in terrains) {
                    ITerrainPlate p = obj as ITerrainPlate;
                    pt = p.Location;
                    // 水平座標を(0,0)に、高さを地形の基準位置にあわせる
                    p.Location = new PointF3D(0, 0, pt.Z - h);
                    yield return p;
                }
            }
            yield break;
        }
        #endregion
    }
}
