﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SysColor = System.Drawing.Color;
using XnaColor = Microsoft.Xna.Framework.Color;
using SysRect = System.Drawing.Rectangle;
using XnaRect = Microsoft.Xna.Framework.Rectangle;
using nft.framework.drawing;
using Microsoft.Xna.Framework;

namespace nft.xna
{
    /// <summary>
    /// XNA coordination               　　NeoFT game space coordination
    /// ｘ ｙ ｚ　　　　　　　　　　　　　　　ｙ ｚ ｘ
    ///  ＼|／ 　yは上が正、x,zは奥が正　　　  ＼|／ 　zは上が正、x,yは奥が正
    /// </summary>
    internal class XnaUtil
    {
        public static SysColor ToSysColor(XnaColor src)
        {
            return SysColor.FromArgb(src.A,src.R,src.G,src.B);
        }

        public static XnaColor ToXnaColor(SysColor src)
        {
            return new XnaColor(src.R, src.G, src.B, src.A);
        }

        public static SysRect ToSysRect(XnaRect src)
        {
            return new SysRect(src.X, src.Y, src.Width, src.Height);
        }

        public static XnaRect ToXnaRect(SysRect src)
        {
            return new XnaRect(src.X, src.Y, src.Width, src.Height);
        }

        public static PointF3D ToPointF(Vector3 src)
        {
            return new PointF3D(src.Z, src.X, src.Y);
        }

        public static Vector3 ToVector3(PointF3D src)
        {
            return new Vector3(src.Y, src.Z, src.X);
        }

        public static Vector3 ToVector3(Point3D src) {
            return new Vector3(src.Y, src.Z, src.X);
        }
        
        public static Vector3[] ToVector3Array(PointF3D[] src) {
            int n = src.Length;
            Vector3[] arr = new Vector3[n];
            for (int i = 0; i < n; i++) {
                arr[i] = ToVector3(src[i]);
            }
            return arr;
        }

        public static Vector3[] ToVector3Array(Point3D[] src) {
            int n = src.Length;
            Vector3[] arr = new Vector3[n];
            for (int i = 0; i < n; i++) {
                arr[i] = ToVector3(src[i]);
            }
            return arr;
        }
    }
}
