#include "stdafx.h"
#include "FormationDelheid.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/lib/util/spline/SplineManufacture.h"
#include "jp/ggaf/lib/util/spline/SplineKurokoLeader.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Alisana/EnemyAlisana.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Delheid/EnemyDelheid.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


FormationDelheid::FormationDelheid(const char* prm_name)
   : DepositoryFormation(prm_name) {
    _class_name = "FormationDelheid";

    pAlisana_start = NEW EnemyAlisana("Alisana_START");
    pAlisana_start->inactivateImmed();
    addSubGroup(pAlisana_start);

    pAlisana_goal = NEW EnemyAlisana("Alisana_GOAL");
    pAlisana_goal->inactivateImmed();
    addSubGroup(pAlisana_goal);

    //OvZp̃_~[
    pDummy_ = NEW EnemyDelheid("DammyEnemyDelheid");
    pDummy_->pKurokoLeader_ = nullptr;
    pDummy_->inactivateImmed();
    addSubGroup(pDummy_);

    //ґf|WgZbg
    pConn_DelheidDepo_ = connect_DepositoryManager("EnemyDelheid4Formation");
    setFormationMember(pConn_DelheidDepo_->peek());
    //ґ̃Vbgf|Wg
    pConn_ShotDepo_ = connect_DepositoryManager("EnemyDelheidShot");

    updateRankParameter();
    useProgress(PROG_LEAVE);
}

void FormationDelheid::updateRankParameter() {
    RV_NumFormation_     = RF_FormationDelheid_Num(G_RANK);    //ґ
    RV_MvVelo_           = RF_FormationDelheid_MvVelo(G_RANK); //x
    RV_IntervalFrames_   = 64 / C_PX(RV_MvVelo_);
}

void FormationDelheid::initialize() {

}

void FormationDelheid::onActive() {
    updateRankParameter();
    _pProg->reset(PROG_INIT);
}

void FormationDelheid::processBehavior() {
    //pAlisana_start j󂳂Ă邩`FbN
    if (pAlisana_start) {
        if (pAlisana_start->onChangeToInactive()) {
            pAlisana_start = nullptr;
        }
    }
    //pAlisana_goal j󂳂Ă邩`FbN
    if (pAlisana_goal) {
        if (pAlisana_goal->onChangeToInactive()) {
            pAlisana_goal = nullptr;
        }
    }

    switch (_pProg->get()) {
         case PROG_INIT: {
             updateRankParameter();
             //_~[(pDummy_)găo[̃XvCړ̊JnʒuƕAIʒuƕ\ߋ߂
             pDummy_->config(getSplManuf()->createKurokoLeader(pDummy_->_pKurokoA), nullptr);
             pDummy_->_pKurokoA->setMvVelo(RV_MvVelo_);
             onCallUpDelheid(pDummy_); //o[(Delheid)̃tH[[VJnWƕ𓾂
             pDummy_->pKurokoLeader_->start(SplineKurokoLeader::RELATIVE_DIRECTION); //WvẐ߃X^[gIvVw肪Kv
             coord next_X, next_Y, next_Z;             //Jn+1 ̕⊮_W
             coord end_X, end_Y, end_Z;                //ŏI̕⊮_W
             coord end_prev_X, end_prev_Y, end_prev_Z; //ŏI-1 ̕⊮_W
             pDummy_->pKurokoLeader_->getPointCoord(1, next_X, next_Y, next_Z);//[0] or [1] C
             int spl_point_num = pDummy_->pKurokoLeader_->getPointNum(); //⊮_̐
             pDummy_->pKurokoLeader_->getPointCoord(spl_point_num-1, end_X, end_Y, end_Z);
             pDummy_->pKurokoLeader_->getPointCoord(spl_point_num-2, end_prev_X, end_prev_Y, end_prev_Z);
             //oJnʒuATiz
             pAlisana_start->positionAs(pDummy_);
             pAlisana_start->_pKurokoA->setFaceAngTwd(next_X, next_Y, next_Z); //Zbg
             pAlisana_start->acitve_open(); //nb`I[v
             //IʒuɃATiz
             pAlisana_goal->position(end_X, end_Y, end_Z);
             pAlisana_goal->_pKurokoA->setFaceAngTwd(end_prev_X, end_prev_Y, end_prev_Z);
             pAlisana_goal->acitve_open((frame)(pDummy_->pKurokoLeader_->getTotalDistance() / RV_MvVelo_)); //nb`I[v\

             pDummy_->sayonara(); //肪Ƃ_~[
             _pProg->changeNext();
             break;
         }
         //nb`oI[v
         case PROG_ENTRY: {
             //Jnnb`݂Ă邩ǂ
             if (pAlisana_start) {
                 if (pAlisana_start->isOpenDone()) {
                     //nb`I[v܂ő҂
                     _pProg->changeNext(); //
                 }
             } else {
                 //Jnnb`I[vOɂꂽ
                 callUpMember(0); //Wł؂
                 _pProg->changeNothing(); //{tH[[V̏II
             }
             //nb`I[v҂
             break;
         }
         //nb`ґo[o
         case PROG_FROMATION_MOVE1: {
             if (pAlisana_start) {
                 //Jnnb`I[vݒ̏ꍇ
                 if (canCallUp()) {
                     //W
                     if (_pProg->getFrameInProgress() % RV_IntervalFrames_ == 0) {
                         //@ RV_NumFormation_ @܂ŏW
                         EnemyDelheid* pDelheid = (EnemyDelheid*)callUpMember(RV_NumFormation_);
                         if (pDelheid) {
                             pDelheid->config(getSplManuf()->createKurokoLeader(pDelheid->_pKurokoA),
                                               pConn_ShotDepo_->peek() );
                             pDelheid->_pKurokoA->forceMvVeloRange(RV_MvVelo_*2);
                             pDelheid->_pKurokoA->setMvVelo(RV_MvVelo_);

                             pDelheid->_pKurokoA->setMvAcce(0);
                             onCallUpDelheid(pDelheid); //ʃtH[[VNXʎ̏
                         } else {
                             //W܂
                         }
                     }
                 } else {
                     //WE
                     pAlisana_start->close_sayonara();
                     _pProg->changeNext(); //oII
                 }
             } else {
                 //Jnnb`(Ȃ)ꍇ
                 callUpMember(0); //Wł؂i{tH[VIuWFNgƂĕKvj
                 _pProg->changeNext(); //oII
             }
             break;
         }

         //So[
         case PROG_FROMATION_MOVE2: {
             if (_pProg->isJustChanged()) {
                 _listFollower.executeFunc(FormationDelheid::order1, this, nullptr);
             }
             if (_pProg->getFrameInProgress() == 120) {
                 _pProg->changeNext();
             }

             break;
         }

         //o[&
         case PROG_FROMATION_MOVE3: {
             if (_pProg->isJustChanged()) {
                 _listFollower.executeFunc(FormationDelheid::order2, this, nullptr);
             }
             if (_pProg->getFrameInProgress() == 360) {
                 _pProg->changeNext(); //؏II
             }
             break;
         }

         //o[Ďn
         case PROG_FROMATION_MOVE4: {
             if (_pProg->isJustChanged()) {
                 _listFollower.executeFunc(FormationDelheid::order3, this, nullptr);
             }
             if (_pProg->getFrameInProgress() == 120) {
                 _pProg->changeNext(); //Ďn
             }
             break;
         }

         //ҋ@
         case PROG_FROMATION_MOVE5: {
             if (_pProg->isJustChanged()) {
             }
             //onSayonaraAll() R[obN҂
             break;
         }

//----------------------------------------------
         //ґo[S@񊈓(onSayonaraAll())
         case PROG_LEAVE: {
             if (_pProg->isJustChanged()) {
                  if (pAlisana_goal) {
                      pAlisana_goal->close_sayonara();
                  }
             }
             break;
         }

         default:
             break;
     }
}

void FormationDelheid::order1(GgafCore::GgafActor* prm_pDelheid, void* prm1, void* prm2) {
    //eo[
    EnemyDelheid* pMember = (EnemyDelheid*)prm_pDelheid;
    FormationDelheid* pFormation = (FormationDelheid*)prm1;
    pMember->_pKurokoA->setMvAcceByT(120, -(pFormation->RV_MvVelo_/8));
}

void FormationDelheid::order2(GgafCore::GgafActor* prm_pDelheid, void* prm1, void* prm2) {
    //eo[&
    EnemyDelheid* pMember = (EnemyDelheid*)prm_pDelheid;
    FormationDelheid* pFormation = (FormationDelheid*)prm1;
    pMember->_pKurokoA->setMvAcce(0);
    pMember->open_shot(); //VbgˁI
}

void FormationDelheid::order3(GgafCore::GgafActor* prm_pDelheid, void* prm1, void* prm2) {
    //eo[Ďn
    EnemyDelheid* pMember = (EnemyDelheid*)prm_pDelheid;
    FormationDelheid* pFormation = (FormationDelheid*)prm1;
    pMember->_pKurokoA->setMvAcceByT(120, pFormation->RV_MvVelo_);
}

void FormationDelheid::onSayonaraAll() {
    //̃R[obNĂяoꂽ_ŁA] FORMATION_END_DELAY t[̂͂
    _TRACE_("FormationDelheid::onSayonaraAll() ł");
    _pProg->change(PROG_LEAVE);
    //҂
}

void FormationDelheid::onDestroyAll(GgafActor* prm_pActor_last_destroyed) {
    UTIL::proceedFormationDestroyAll((GgafDxDrawableActor*)prm_pActor_last_destroyed);
}

FormationDelheid::~FormationDelheid() {
    pConn_ShotDepo_->close();
    pConn_DelheidDepo_->close();
}

