#include "stdafx.h"
#include "EnemyEmusLaserChip001.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


EnemyEmusLaserChip001::EnemyEmusLaserChip001(const char* prm_name) :
        WateringLaserChip(prm_name, "EmusLaserChip001", STATUS(EnemyEmusLaserChip001)) {
    _class_name = "EnemyEmusLaserChip001";
}

void EnemyEmusLaserChip001::initialize() {
    registerHitAreaCube_AutoGenMidColli(20000);
    setHitAble(true, false);
    setScaleR(5.0);
    setAlpha(0.9);
    _pKurokoA->setMvVelo(300000);
    _pKurokoA->relateMvFaceAng(true);
}

void EnemyEmusLaserChip001::onActive() {
    WateringLaserChip::onActive();
    //Xe[^XZbg
    _pStatus->reset();
}

void EnemyEmusLaserChip001::processBehavior() {
    _pKurokoA->behave();
    WateringLaserChip::processBehavior();
}

void EnemyEmusLaserChip001::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    if (getActiveFrame() < 30 && (pOther->getKind() & KIND_CHIKEI)) {
        //o30t[ȓŃqbg肪n`ȂΖion`ɂj󂳂j
        return;
    }
    //qbg
    //̗͌vZ
    int sta = UTIL::calcEnemyStamina(this, pOther);
    if (sta <= 0) {
        //qbgďŎ
        sayonara();
    } else {
        //qbgĐ
    }
}
void EnemyEmusLaserChip001::onInactive() {
    WateringLaserChip::onInactive();
}

EnemyEmusLaserChip001::~EnemyEmusLaserChip001() {
}

