#ifndef GGAFCORE_GGAFNODE_H_
#define GGAFCORE_GGAFNODE_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include <cstring>
#include "jp/ggaf/core/util/GgafUtil.h"
#include "jp/ggaf/core/exception/GgafCriticalException.h"

namespace GgafCore {

/**
 * vfmoAXg([)ŁAc[\邱Ƃłev[głB.
 * c[m[hAZm[hoAXgŌOʒu֌W̊TOB
 * ܂AZm[hɐ擪m[hAm[h̊TOB擪m[hƖm[h̓tOŊǗB
 * Ȃ̂Ő擪m[hAm[h݂͌ɘAĂB
 * m[h͎livfCX^Xjw킯ł͂ȂAm[h̃IuWFNgglƂĂB
 * ܂AReiɔ񂸁B<BR>
 * łQƉ񐔂炵AptH[}Xグ悤ƂׁEEEB<BR>
 *
 * <B>yz</B><BR>
 * <PRE STYLE="font-size:12px">
 * EÊóEEE
 *       
 * (d)̂`̂âb̂ĉd(`)
 *             
 *                                       
 *     (g)̂êf̂g(e)        (k)̂ĥîĵk(h)
 *                                               
 *                 EEE                              EEE
 * </PRE>
 * }̂悤ȍ\̂鎖o܂B<BR>
 * íu(d)̂`̂âb̂ĉd(`)v͗vfiCX^Xj̑oŃ|C^wĂ鎖Ă܂B<BR>
 * [́u(d)vƁu(`)v́AAXg̐擪ƖA݂AĂ鎖𖾎Ă܂B(ɂȂĂ)<BR>
 * }Ŏg̃CX^XubvƂꍇAubv̎_evf̂悤Ɍď́Ayђ`邱ƂƂ܂B<BR>
 * <TABLE BORDER="1">
 * <TR><TD>ubv</TD><TD>m[h</TD></TR>
 * <TR><TD>u`v</TD><TD>擪(First)m[hB m[hAXgiZm[hj̐擪ƂӖłBu`v  _is_first_flg  true ɂȂĂ܂B(m[h false)</TD></TR>
 * <TR><TD>udv</TD><TD>(Last)m[hB m[hAXgiZm[hj̍ŌƂӖłBudv  _is_last_flg  true ɂȂĂ܂B(̃m[h false)</TD></TR>
 * <TR><TD>ucv</TD><TD>(Next)m[hB}ł͍EƂĂ܂B_pNext|C^wĂvfɂȂ܂B</TD></TR>
 * <TR><TD>uav</TD><TD>O(Prev)m[hB_pPrev wĂ|C^łB</TD></TR>
 * <TR><TD>uov</TD><TD>e(Parent)m[hBm[hAXĝP̊Kw̃m[hłB_pParent |C^wĂvfłBSẴm[h͒߂̐em[h̃|C^Ă܂B</TD></TR>
 * <TR><TD>uhCiCjCkv</TD><TD>ubvq(Sub)m[hƌĂт܂B</TD></TR>
 * <TR><TD>uhv</TD><TD> qm[h̒œɁuhv͎qm[h̐擪m[hƌĂсAm[h _pSubFirst |C^wĂvfƂȂĂ܂B</TD></TR>
 * </TABLE>
 * <BR>
 *
 * <B>y̑p⑫z</B>
 * <TABLE BORDER="1">
 * <TR>
 * <TD>um[hvuv</TD>
 * <TD>m[hȊÕm[hSĂwĂ܂B</TD>
 * </TR><TR>
 * <TD>uzm[hvuzv</TD>
 * <TD>m[hm̃c[Kw\ɂāAm[h<B></B>Ԃ牺SẴm[hwĂ܂Bm[h͊܂܂܂B</TD>
 * </TR><TR>
 * <TD>uc[v</TD>
 * <TD>m[h𒸓_ƂAm[h{zm[hō\c[\̂w܂B</TD>
 * </TR><TR>
 * <TD>uc[m[hv</TD>
 * <TD>m[h𒸓_ƂAm[h{zm[hō\c[\̃m[hSĂw܂B</TD>
 * </TR><TR>
 * <TD>uc[v</TD>
 * <TD>m[h܂܂Ăc[\̑SĂw܂B</TD>
 * </TR><TR>
 * <TD>um[hNXv</TD>
 * <TD>GgafNodeNXAGgafNodeNX𒼐ځEԐڌpĂNXw܂B</TD>
 * </TR><TR>
 * <TD>uʁvuʁv</TD>
 * <TD>m[hNX̃NXp֌W\Ă܂B
 * {hLgł́ANXp֌W̕\́uX[p[vuTuv́uevuqvƌ킸<B>uʁvuʁv</B>œꂷ邱Ƃɂ܂B<BR>
 * uevuqvƕ\ꍇ͂ꂼem[hAqm[h̃c[\̎\̂Ƃ܂Bi₱łˁj<BR>
 * ၄<BR>
 * EʂHogehogeŎꂽRRB<BR>
 *      ӖFHogehogeNXpAŎĂRR<BR>
 * ETuHogehogeŎꂽRRB<BR>
 *      ӖFc[\̎qm[hɂHogehogeNXIuWFNgŎĂRR<BR>
 * </TD>
 * </TR>
 * </TABLE>
 * @tparam T Ǘvf̌^ǐ^̃|C^^ŊǗBj
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */

template<class T>
class GgafNode : public GgafObject {

public:
    /** [r]m[hʖ(50܂) */
    char* _name;
    /** [r]NXifobOŎgp܂j */
    const char* _class_name;
    /** [r]em[h */
    T* _pParent;
    /** [r]m[h */
    T* _pNext;
    /** [r]Om[h */
    T* _pPrev;
    /** [r]qm[h̐擪m[h */
    T* _pSubFirst;
    /** [r]擪m[htO (m[h擪m[h̏ꍇ true)*/
    bool _is_first_flg;
    /** [r]m[htO (m[hm[h̏ꍇ true)*/
    bool _is_last_flg;
    /** [r]qm[h̐ */
    int _sub_num;

public:
    /**
     * RXgN^
     * @param prm_name m[h́ij[Nɂĉj
     */
    explicit GgafNode(const char* prm_name);

    /**
     * fXgN^Bc[m[h܂B .
     * m[hqm[hꍇAqm[hĂ玩gB<BR>
     * m[hŏIm[hꍇAm[hA痣EAOm[hŏIm[htOZbgāAgB<BR>
     * m[h擪m[hꍇAm[hA痣EAm[hem[h  qm[h̐擪m[hA 擪m[htOZbgAgB<BR>
     * m[hԃm[hꍇÃׂm[h̘Ač\zB<BR>
     * m[h̘AgwiPlڂjꍇAem[h  qm[h̐擪m[hiwĂjnullptrɕύXĂB<BR>
     * ̂悤ȍ\̏ꍇAm[h P deleteƁA͇@`L̏ƂȂB<BR>
     * m[hԂŎQƊ֌Wꍇ́AӂKvB<BR>
     * <pre>
     * (o)̇Lo(o)
     *         
     * (d)̇K`̇GȧBḃAċ@d(`)
     *             
     *                                       
     * (g)̇JėIḟHg(e)    (k)̇FḣEi̇Dj̇Ck(h)
     *
     * Tu݂΂DŖm[hĂB
     * </pre>
     */
    virtual ~GgafNode();

    /**
     * m[h擾 .
     * @return m[h
     */
    inline virtual char* getName() const {
        return _name;
    }

    /**
     * NX擾 .
     * @return NX
     */
    inline virtual const char* getClassName() const {
        return _class_name;
    }

    /**
     * P̐em[hݒ肷B
     * @param	prm_pParent	em[h
     */
    inline virtual void setParent(T* prm_pParent) {
        _pParent = prm_pParent;
    }

    /**
     * c[m[hAXg؂藣AƗB .
     * ؂藣ꌊJ́Ãm[h𖄂߂܂iĘA܂j<BR>
     * m[hɎqԂ牺ĂꍇA؂藣ꂽƂɂȂ܂B<BR>
     * @return	T* m[h̃|C^
     */
    virtual T* extract();

    /**
     * m[hAŏIm[hֈړ .
     * qm[hAɂĈړ܂Bm[hƎqm[h̊֌W͕܂B<BR>
     *<PRE>
     * ----------------usOv
     *         e
     *         
     * idĵ`̂âb̂ĉd́i`j
     * -----------------------
     *         }ŎubvƂꍇÂ悤ȏԂɂȂ
     * ----------------usv
     *         e
     *         
     * idĵ`̂âĉd̂b́i`j
     * -----------------------
     * </PRE>
     */
    virtual void moveLast();

    /**
     * m[hA擪m[hֈړ .
     * qm[hAɂĈړ܂Bm[hƎqm[h̊֌W͕܂B<BR>
     *<PRE>
     * ----------------usOv
     *       e
     *       
     * (d)̂`̂âb̂ĉd(`)
     * -----------------------
     *         }ŎubvƂꍇÂ悤ȏԂɂȂ
     * ----------------usv
     *       e
     *       
     * (d)̂b̂`̂âĉd(b)
     * -----------------------
     * </PRE>
     */
    virtual void moveFirst();

    /**
     * ̃m[h擾B
     * @return	T*	m[h
     */
    inline virtual T* getNext() const {
        return _pNext;
    }

    /**
     * Õm[h擾B
     * @return	T*	Om[h
     */
    inline virtual T* getPrev() const {
        return _pPrev;
    }

    /**
     * P̐em[h擾B
     * @return	T*	em[h
     */
    inline virtual T* getParent() const {
        return _pParent;
    }

    /**
     * m[hqm[h̍Ōɒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B<BR>
     *<PRE>
     * ----------------usOv
     *       b
     *       
     * (j)̂ĥîj(h)
     * -----------------------
     *          }ŎubvƂꍇAɃm[huwvaddSubLast 
     *          ̂悤ȏԂɂȂ
     * ----------------usv
     *       b
     *       
     * (w)̂ĥîĵw(h)
     * -----------------------
     * </PRE>
     *
     * @param   prm_pSub    CX^Xς݃m[h̃|C^
     */
    virtual void addSubLast(T* prm_pSub);

    /**
     * m[hqm[h̐擪ɒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B<BR>
     *<PRE>
     * ----------------usOv
     *       b
     *       
     * (j)̂ĥîj(h)
     * -----------------------
     *          }ŎubvƂꍇAɃm[huwvaddSubFirst 
     *          ̂悤ȏԂɂȂ
     * ----------------usv
     *       b
     *       
     * (j)̂ŵĥîj(w)
     * -----------------------
     * </PRE>
     *
     * @param   prm_pSub    CX^Xς݃m[h̃|C^
     */
    virtual void addSubFirst(T* prm_pSub);

    /**
     * qm[hm[ĥw肵Ď擾 .
     * ݂Ȃꍇ̓G[<BR>
     *  char* ̔r܂ōs߁AdłB<BR>
     * t[s悤Ȏgpׂ͔łB<BR>
     * @param	prm_sub_name	qm[h
     * @return	T*	ŏɃqbgqm[hɑΉqm[h̃|C^
     */
    virtual T* getSubByName(const char* prm_sub_name);

    /**
     * ̃m[hqm[hɑ݂ꍇ擾 .
     * @param prm_pSub qm[h
     * @return ݂ꍇqm[hԂA݂Ȃꍇ nullptr Ԃ
     */
    virtual T* getSub(T* prm_pSub) const;

    /**
     * qm[h擪̃CfbNXwŎ擾 .
     * 0  _pSubFirst ƓB
     * @param prm_index CfbNX(0`)
     * @return
     */
    virtual T* getSub(int prm_index) const;

    /**
     * qm[h̃O[v̐擪m[h擾 .
     * qm[h݂ȂꍇnullptrB
     * @return	T*	qm[h̐擪m[h
     */
    inline virtual T* getSubFirst() const {
        return _pSubFirst;
    }

    /**
     * qm[h̃O[v̖m[h擾 .
     * qm[h݂ȂꍇnullptrB
     * @return T*   qm[h̖m[h
     */
    inline virtual T* getSubLast() const {
        if (_pSubFirst) {
            return _pSubFirst->_pPrev;
        } else {
            return nullptr;
        }
    }

    /**
     * qm[h݃`FbN .
     *  char* ̔r܂ōs߁AdłB<BR>
     * t[s悤Ȏgpׂ͔łB<BR>
     * @param	prm_sub_actor_name	݃`FbNqm[h
     * @return	bool true:݂^false:݂Ȃ
     */
    virtual bool hasSub(char* prm_sub_actor_name) const;


    /**
     * qm[h擾 .
     * @return  T*  qm[h
     */
    inline virtual int getNumSub() const {
        return _sub_num;
    }

    /**
     * m[h擪m[hׂ .
     * @return	bool true:擪m[h^false:擪m[hł͂Ȃ
     */
    inline virtual bool isFirst() const {
        return _is_first_flg;
    }

    /**
     * m[hm[hׂ .
     * @return	bool true:m[h^false:m[hł͂Ȃ
     */
    inline virtual bool isLast() const {
        return _is_last_flg;
    }

    virtual char* toString() override {
        return getName();
    }

};

//////////////////////////////////////////////////////////////////

/**
 * ͎
 */
template<class T>
GgafNode<T>::GgafNode(const char* prm_name) :
    GgafObject(),
    _name(nullptr),
    _class_name("GgafNode<T>"),
    _pParent(nullptr),
    _pNext((T*)this),
    _pPrev((T*)this),
    _pSubFirst(nullptr),
    _is_first_flg(true),
    _is_last_flg(true),
    _sub_num(0)
{
    int len = strlen(prm_name);
    _name = NEW char[len+1];
    strcpy(_name, prm_name);

//#ifdef MY_DEBUG
//    if (strlen(prm_name) > 49) {
//        throwGgafCriticalException("[GgafNode RXgN^ Error! prm_name ̕I[o[ prm_name="<<prm_name<<"");
//    }
//    if (strlen(prm_name) == 0) {
//        throwGgafCriticalException("[GgafNode RXgN^ Error! prm_name ̕0prm_name="<<prm_name<<"");
//
//    }
//#endif
//    _name = NEW char[51];
//    strcpy(_name, prm_name);
}

template<class T>
T* GgafNode<T>::extract() {
    if (_pParent) {
        //AO
        _pParent->_sub_num--;
        T* pMyNext = _pNext;
        T* pMyPrev = _pPrev;
        if (_is_first_flg && _is_last_flg) {
            //Âݏꍇ
            _pParent->_pSubFirst = nullptr;
        } else {
            //A甲oꍇ
            //ׂ̃m[hmqAwȂB
            pMyPrev->_pNext = pMyNext;
            pMyNext->_pPrev = pMyPrev;
            if (_is_last_flg) {
                pMyPrev->_is_last_flg = true;
            }
            if (_is_first_flg) {
                pMyNext->_is_first_flg = true;
                _pParent->_pSubFirst = pMyNext;
            }
        }
        _pParent = nullptr;
        _pNext = (T*)this;
        _pPrev = (T*)this;
        _is_first_flg = true;
        _is_last_flg = true;
        //c[͈ێ̂ŁA_pSubFirst ̂܂܁inullptrɂȂj
        return ((T*)this);
    } else {
        //TODO:RRɏꍇ́Aextract()KvȂB
        //_pParentȂɂĂȂextract()KvȂB
        //ƁA߂Ă邪ÁAvfǉ邽߂̃\bh addSubLast() addSubFirst() ݂̂ł邱ƂOƂȂB
        //addSubLast() addSubFirst() ݂̂ōc[\́Ae̒_͏ɗBƂȂ邩炾B
        //AaddNext() ̂悤ɗׂɗvfǉ郁\bhȂ΂ȂȂꍇA
        //e̒_юȂA`̂悤ȍ\̂悤ɂꍇ́A
        //̏ꏊɉÂݐ؂藣ǉKv鎖YꂸɁB

        return ((T*)this);
    }
}

template<class T>
void GgafNode<T>::moveLast() {
    if (_is_last_flg) { //ɍŏIm[hȂΉȂ
        return;
    } else if (_is_first_flg) { //擪m[hȂ΁Ae̎wĂ擪m[hւ炷
        _pParent->_pSubFirst = _pNext;
        _pPrev->_is_last_flg = false;
        _is_first_flg = false;
        _is_last_flg = true;
        _pNext->_is_first_flg = true;
    } else { //ԃm[h
        //ׂ̃m[hmq
        _pPrev->_pNext = _pNext;
        _pNext->_pPrev = _pPrev;
        //m[hƐ擪m[h̊Ԃɂ肱܂
        T* pFirst = _pParent->_pSubFirst; //First
        T* pLast = pFirst->_pPrev;        //Last
        pLast->_is_last_flg = false;      //LastLasttO
        _is_last_flg = true;              //VLasttOZbg
        _pPrev = pLast;                   //̑O͌Last
        _pNext = pFirst;                  //̎͌FirstB
        pLast->_pNext = (T*)this;         //Last͉̎
        pFirst->_pPrev = (T*)this;        //First̑O͉ƂȂB
    }
}

template<class T>
void GgafNode<T>::moveFirst() {
    if (_is_first_flg) { //ɐ擪m[hȂΉȂ
        return;
    } else if (_is_last_flg) { //m[hȂ΁Ae̎wĂ擪m[hOɂ炷
        _pParent->_pSubFirst = (T*)this;
        _pPrev->_is_last_flg = true;
        _is_first_flg = true;
        _is_last_flg = false;
        _pNext->_is_first_flg = false;
    } else { //ԃm[h
        //ׂ̃m[hmq
        _pPrev->_pNext = _pNext;
        _pNext->_pPrev = _pPrev;
        //m[hƐ擪m[h̊Ԃɂ肱܂
        T* pFirst = _pParent->_pSubFirst; //First
        T* pLast = pFirst->_pPrev;        //Last
        pFirst->_is_first_flg = false;    //FirstFirsttO
        _is_first_flg = true;             //VFirsttOZbg
        _pPrev = pLast;                   //̑O͌LastŁA
        _pNext = pFirst;                  //̎͌FirstB
        pLast->_pNext = (T*)this;         //Last͉̎ŁA
        pFirst->_pPrev = (T*)this;        //First̑O͉ƂȂB
        _pParent->_pSubFirst = (T*)this;  //ɁAeSubFirstƂȂ̂B
    }
}

template<class T>
T* GgafNode<T>::getSubByName(const char* prm_sub_name) {
#ifdef MY_DEBUG
    if (_pSubFirst == nullptr) {
        throwGgafCriticalException("[GgafNode<" << _class_name << ">::getSub()] Error! _pSubFirstnullptrłB");
    }
#endif
    T* pNodeTemp = _pSubFirst;
    do {
        if (strcmp(pNodeTemp->getName(), prm_sub_name) == 0) {
            break;
        }
#ifdef MY_DEBUG
        if (pNodeTemp->_is_last_flg) {
            throwGgafCriticalException("[GgafNode<" << _class_name << ">::getSub()] Error! qm[h݂͑܂B(prm_sub_actor_name=" << prm_sub_name << ")");
        }
#endif
        pNodeTemp = pNodeTemp->_pNext;
    } while (true);
    return pNodeTemp;
}

template<class T>
T* GgafNode<T>::getSub(T* prm_pSub) const {
    if (_pSubFirst == nullptr) {
        return nullptr;
    }
    T* pNodeTemp = _pSubFirst;
    do {
        if (prm_pSub == pNodeTemp) {
            break;
        }
        if (pNodeTemp->_is_last_flg) {
            return nullptr;
        }
        pNodeTemp = pNodeTemp->_pNext;
    } while (true);
    return pNodeTemp;
}

template<class T>
T* GgafNode<T>::getSub(int prm_index) const {
    T* pNodeTemp = _pSubFirst;
    for (int i = 0; i < prm_index; i++) {
        pNodeTemp = pNodeTemp->_pNext;
    }
    return pNodeTemp;
}

template<class T>
bool GgafNode<T>::hasSub(char* prm_sub_actor_name) const {
    if (_pSubFirst == nullptr) {
        return false;
    } else {
        T* pNodeTemp = _pSubFirst;
        do {
            if (strcmp(pNodeTemp->getName(), prm_sub_actor_name) == 0) {
                return true;
            }
            if (pNodeTemp->_is_last_flg) {
                return false;
            } else {
                pNodeTemp = pNodeTemp->_pNext;
            }
        } while (true);
    }
}

template<class T>
void GgafNode<T>::addSubLast(T* prm_pSub) {
#ifdef MY_DEBUG
    if (prm_pSub->_pParent) {
        throwGgafCriticalException("[GgafNode<" << _class_name << ">::addSubLast()] Error! m[h͊ɏ("
                << prm_pSub->_pParent->_name << "ɏ)Ă܂(this=" << _name << "/prm_pSub=" << prm_pSub->getName() << ")");
    }
#endif
    prm_pSub->_pParent = (T*)this;
    prm_pSub->_is_last_flg = true;
    if (_pSubFirst == nullptr) { //ŏ̃Tu
        prm_pSub->_is_first_flg = true;
        _pSubFirst = prm_pSub;
        _pSubFirst->_pNext = prm_pSub;
        _pSubFirst->_pPrev = prm_pSub;
    } else {  //Qڈȍ~̃Tu
        prm_pSub->_is_first_flg = false;
        T* pSubLast = _pSubFirst->_pPrev;
        pSubLast->_is_last_flg = false;
        pSubLast->_pNext = prm_pSub;
        prm_pSub->_pPrev = pSubLast;
        prm_pSub->_pNext = _pSubFirst;
        _pSubFirst->_pPrev = prm_pSub;
    }
    _sub_num++;
}

template<class T>
void GgafNode<T>::addSubFirst(T* prm_pSub) {
#ifdef MY_DEBUG
    if (prm_pSub->_pParent) {
        throwGgafCriticalException("[GgafNode<" << _class_name << ">::addSubFirst()] Error! m[h͊ɏ("
                << prm_pSub->_pParent->_name << "ɏ)Ă܂(this=" << _name << "/prm_pSub=" << prm_pSub->getName() << ")");
    }
#endif
    prm_pSub->_pParent = (T*)this;
    prm_pSub->_is_first_flg = true;
    if (_pSubFirst == nullptr) { //ŏ̃Tu
        prm_pSub->_is_last_flg = true;
        prm_pSub->_pNext = prm_pSub;
        prm_pSub->_pPrev = prm_pSub;
    } else {
        prm_pSub->_is_last_flg = false;
        T* pSubLast = _pSubFirst->_pPrev;
        pSubLast->_pNext = prm_pSub;
        prm_pSub->_pPrev = pSubLast;
        prm_pSub->_pNext = _pSubFirst;
        _pSubFirst->_pPrev = prm_pSub;
        _pSubFirst->_is_first_flg = false;
    }
    _pSubFirst = prm_pSub;

    _sub_num++;
}

/*
 template<class T>
 bool GgafNode<T>::isNamed(const char* prm_name) {
 char*::size_type iLen = prm_name.length();
 if (prm_name.rfind('*') == iLen-1) {}


 return _name;
 }
 */


template<class T>
GgafNode<T>::~GgafNode() {
    //Ɏqꍇ
    if (_pSubFirst) {
        //܂qdelete
        if (_pSubFirst->_is_last_flg) {
            //qm[h͂P̏ꍇ
            GGAF_DELETE(_pSubFirst);
            _pSubFirst = nullptr;
        } else {
            //qm[h͂Qȏ̏ꍇ
            T* pSubLast = _pSubFirst->_pPrev;
            T* pSubLastPrev = pSubLast->_pPrev;
            while (true) {
                GGAF_DELETE(pSubLast); //delete
                if (pSubLastPrev->_is_first_flg) {
                    GGAF_DELETE(_pSubFirst); //pSubLastPrev == _pSubFirst ł
                    _pSubFirst = nullptr;
                    break;
                }
                pSubLast = pSubLastPrev;
                pSubLastPrev = pSubLastPrev->_pPrev;
            }
        }
    }

    //qȂԂ̏ꍇ
    if (_pParent) {
        _pParent->_sub_num--;
        //AO
        T* pMyNext = _pNext;
        T* pMyPrev = _pPrev;
        if (_is_first_flg && _is_last_flg) {
            //AĂm[hÂݏꍇ
            _pParent->_pSubFirst = nullptr;
            _pParent = nullptr;
            _pNext = (T*)this;
            _pPrev = (T*)this;
            _pSubFirst = nullptr;
        } else {
            //A甲oꍇ
            //ׂ̃m[hmqAwȂB
            pMyPrev->_pNext = pMyNext;
            pMyNext->_pPrev = pMyPrev;
            if (_is_last_flg) {
                pMyPrev->_is_last_flg = true;
            }
            if (_is_first_flg) {
                pMyNext->_is_first_flg = true;
                _pParent->_pSubFirst = pMyNext;
            }
            _pParent = nullptr;
            _pNext = (T*)this;
            _pPrev = (T*)this;
            _pSubFirst = nullptr;
            _is_first_flg = true;
            _is_last_flg = true;
        }
    }
    GGAF_DELETEARR(_name);
}

}
#endif /*GGAFCORE_GGAFNODE_H_*/
