#ifndef GGAFCORE_GGAFLINEARQUADTREE_H_
#define GGAFCORE_GGAFLINEARQUADTREE_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/core/util/GgafTreeSpace.hpp"
#include "jp/ggaf/core/util/GgafTreeElem.hpp"

namespace GgafCore {

/**
 * `l؃NX .
 * `l؂Ƃ́Al؋ԕ@̊eԂA̔z(`)ɕׂԂӖ܂B
 * {NXł̗p̂悤ɒ߂鎖ƂB
  * <pre><code>
 *  +-----------+
 *  |           |
 *  |           |
 *  |     0     |
 *  |           |   Lv0 
 *  |           |
 *  |           |
 *  +-----------+
 *
 *  +-----+-----+
 *  |     |     |
 *  |  0  |  1  |
 *  |     |     |
 *  +-----+-----+   Lv1 
 *  |     |     |
 *  |  2  |  3  |
 *  |     |     |
 *  +-----+-----+
 *
 *  +--+--+--+--+
 *  | 0| 1| 4| 5|
 *  +--+--+--+--+
 *  | 2| 3| 6| 7|
 *  +--+--+--+--+   Lv2 
 *  | 8| 9|12|13|
 *  +--+--+--+--+
 *  |10|11|14|15|
 *  +--+--+--+--+
 * </code></pre>
 * <BR>
 * <B>p`</B>
 * <BR>
 * <B>[g</B><BR>
 * Ẑ悤ȏԂŔԍU@ԂwtB
 * 4؂ł͕ʂ4AEAAȄŐUu@v̎B<BR>
 * <BR>
 * <B>ԃx</B><BR>
 * L}̉EɏĂAeԂ̃xwB<BR>
 * <BR>
 * <B>[gʂԍAԔԍ</B><BR>
 * L}̊eLevelԂɐUĂ镪Ԃ̔ԍ̂ƂwƂB<BR>
 * L}̗łLv1Ԃ̃[gʂԍ 0`3ALv2Ԃ̃[gʂԍ0`15 Ƃ悤ɎgB<BR>
 * <BR>
 * <B>qԁAeԁBiqxAexj</B><BR>
 * ԃx +1 qԁAԃx -1 eԂƌĂԂƂɂB<BR>
 * <BR>
 * <B>[gʒu</B><BR>
 * Ԃ4AAEAAE
 * ꂼ 0 1 2 3 (8؂ł 0`7)ƕ\ꍇA
 *  0 1 2 3 ̎[gʒuƌĂԂƂƂB<BR>
 * <BR>
 * <B>(z)vfԍ</B><BR>
 * ԔԍɑΉ`z̃CfbNXwB<BR>
 * ̓Iɂ _paQuadrant ̗vfԍB<BR>
 * <BR>
 *
 *  <B>yPz</B><BR>
 *  Lv2 Ԃ [gʒu 2 ̋ԂƂ
 *  <pre><code>
 *  +--+--+
 *  | 8| 9|
 *  +--+--+
 *  |10|11|
 *  +--+--+
 *  </code></pre>
 *  wƂƂB<BR>
 *
 *  <B>yQz</B><BR>
 *  uLv1Ԃ̋Ԕԍ3̎qԂ̃[gʒu2vƕ\ꍇ́A
 *  Lv1̋Ԕԍ3̎qԁLv2ԂS̉E
 *  <pre><code>
 *  +--+--+
 *  |12|13|
 *  +--+--+
 *  |14|15|
 *  +--+--+
 *  </code></pre>
 *  ̂ƂwÃ[gʒu2Ȃ̂ŁALv2ԃ[gʂԍ<B>14</B>wĂ邱ƂƂB<BR>
 *  y̑gpz<BR>
 *  ELv1 Ԃ̃[gʒu 1  Lv2 Ԃ̋Ԕԍ 4 5 6 7 ɓB<BR>
 *  ELv2 Ԕԍ 13 ́AeԂ̃[gʒu 3 ɑ݂B<BR>
 *  Ƃ悤ɕ\肷iƒ`jB<BR>
 * <BR>
 * yӎz<BR>
 * {vÓA<BR>
 * u~i܂؂j[ǂƃRv http://marupeke296.com/index.html<BR>
 * TCgRec u8 4؋ԕœKIv http://marupeke296.com/COL_2D_No8_QuadTree.html<BR>
 * ̋LQlɁiƂwǂ̂܂܁j쐬Ă܂B<BR>
 * ڂ؂̔ɉ₷Ɋӂ܂B<BR>
 * <BR>
 * @version 1.00
 * @since 2017/08/02
 * @author Masatoshi Tsuge
 */
class GgafLinearQuadtree : public GgafObject {

private:
    /**
     * LevelԂ̎l؃[g̒ʂԔԍ擾 .
     * LevelƂ <BR>
     * uƌʂ͓levelԂłv<BR>
     * ƂӖB{\bḧ͔CӂLevelԂ󂯓B<BR>
     * Ă邱Ƃ<BR>
     * Eꂼ3bitƂɊԊuJ<BR>
     * E2̌ʂ1rbgA2̌ʂ2rbg  炵 OR <BR>
     * ȏB<BR>
     * <BR>
     * }ƁA܂
     * <pre><code>
     * 000000000000000000000000abcdefgh ,
     * 000000000000000000000000ijklmnop ,
     * 
     * 0000000000000000 0a 0b 0c 0d 0e 0f 0g 0h  --> X
     * 0000000000000000 i0 j0 k0 l0 m0 n0 o0 p0  --> Y
     * āAOR(̌)߂lɂȂBӖ́A
     * 0000000000000000 ia jb kc ld me nf og ph
     *                                       ^^-->&B(ph)        = Level̋Ԃ̃[gʂԔԍ 0`3
     *                                    ^^ ^^-->&B(ogph)      = Level̐eԂ̃[gʂԔԍ 0`15
     *                                 ^^ ^^ ^^-->&B(nfogph)    = Level̐e̐eԂ̃[gʂԔԍ 0`63
     *                              ^^ ^^ ^^ ^^
     *                               |  |  |  |
     *                               |  |  |  &B(ph) = Level̋Ԃ̃[g̈ʒu 0`3
     *                 ............  |  |  `---&B(og) = Level̐eԂ̃[g̈ʒu  0`3
     *                               |  `-------&B(nf) = Level̐e̐e̋Ԃ̃[g̈ʒu 0`3
     * </code></pre>
     * @param x_space_index ̃xԂxWԃCfbNX ( 0`255 Ƃ)
     * @param y_space_index ̃xԂyWԃCfbNX ( 0`255 Ƃ)
     * @return LevellԂ(x_index, y_index)ŎԂɑΉ
     *         l؃[g̒ʂԔԍ(őLevel8ŁA0`87380)
     */
    static inline uint32_t getMortonOrderNumFromXYindex( uint32_t x_space_index, uint32_t y_space_index) {
        return GgafLinearQuadtree::separateEveryTwoBit(x_space_index) |
               GgafLinearQuadtree::separateEveryTwoBit(y_space_index)<<1;
    }

    /**
     * 2bitƂɊԊuJ .
     * <pre><code>
     * 0000000000000000abcdefghijklmnop  
     * 0a0b0c0d0e0f0g0h0i0j0k0l0m0n0o0p  ɂ܂
     * ASY
     * n          = 0000 0000 0000 0000 abcd efgh ijkl mnop ̂Ƃ
     * n<<8       = 0000 0000 abcd efgh ijkl mnop 0000 0000
     * n|n<<8     = 0000 0000 abcd efgh ???? ???? ijkl mnop
     * 0x00ff00ff = 0000 0000 1111 1111 0000 0000 1111 1111 ł̂
     * (n|n<<8) & 0x00ff00ff =
     *              0000 0000 abcd efgh 0000 0000 ijkl mnop ƂȂB
     * ̌ʂ܂ n ɑ(ȉl)
     * n          = 0000 0000 abcd efgh 0000 0000 ijkl mnop
     * n<<4       = 0000 abcd efgh 0000 0000 ijkl mnop 0000
     * n|n<<4     = 0000 abcd ???? efgh 0000 ijkl ???? mnop
     * 0x0f0f0f0f = 0000 1111 0000 1111 0000 1111 0000 1111
     * n  (n|n<<4) & 0x0f0f0f0f =
     *              0000 abcd 0000 efgh 0000 ijkl 0000 mnop
     * n<<2       = 00ab cd00 00ef gh00 00ij kl00 00mn op00
     * n|n(n<<2)  = 00ab ??cd 00ef ??gh 00ij ??kl 00mn ??op
     * 0x33333333 = 0011 0011 0011 0011 0011 0011 0011 0011
     * n  (n|n<<2) & 0x33333333 =
     *              00ab 00cd 00ef 00gh 00ij 00kl 00mn 00op
     * n<<1       = 0ab0 0cd0 0ef0 0gh0 0ij0 0kl0 0mn0 0op0
     * n|n(n<<1)  = 0a?b 0c?d 0e?f 0g?h 0i?j 0k?l 0m?n 0o?p
     * 0x55555555 = 0101 0101 0101 0101 0101 0101 0101 0101
     * n  (n|n<<2) & 0x55555555 =
     *              0a0b 0c0d 0e0f 0g0h 0i0j 0k0l 0m0n 0o0p
     * </code></pre>
     * @param n 0`255܂ł̐l
     * @return 3bitƂɊԊu󂯂ꂽl
     */
    static inline uint32_t separateEveryTwoBit(uint32_t n) {
           n = (n | (n<<8) ) & 0x00ff00ff;
           n = (n | (n<<4) ) & 0x0f0f0f0f;
           n = (n | (n<<2) ) & 0x33333333;
           return (n | (n<<1) ) & 0x55555555;
    }

public:
    /** [r]l؂̋Ԃ꒼ɕׂ`z */
    GgafTreeSpace<2u>* _paQuadrant; //_paQuadrant[0]  ROOTԂւ̃|C^
    /** [r]l؂̋Ԃɓo^svf̐擪vf */
    GgafTreeElem<2u>* _pRegElemFirst;
    /** [r]rootԂ̑Ίp̒_ƂȂxW̏ */
    int _root_x1;
    /** [r]rootԂ̑Ίp̒_ƂȂyW̏ */
    int _root_y1;
    /** [r]rootԂ̑Ίp̒_ƂȂzW̏ */
    int _root_x2;
    /** [r]rootԂ̑Ίp̒_ƂȂyW傫 */
    int _root_y2;
    /** [r]ŏ(=ō̋)1ԂX̋ */
    int _top_level_dx;
    /** [r]ŏ(=ō̋)1ԂY̋ */
    int _top_level_dy;

    double _r_top_level_dx;
    double _r_top_level_dy;

    /** [r]8̗ݏ̒l\ߌvZĕێĂz */
    uint32_t* _pa_4pow;
    /** [r]SԐ */
    uint32_t _num_space;
    /** [r]őԃx */
    int _top_space_level; //[gԂLevel=0

public:
    /**
     * `l؋Ԃ\z.
     * @param prm_level \zԃx
     */
    GgafLinearQuadtree(int prm_level);

    /**
     * ԃx0͈̎͂XV.
     * ύX\B
     * @param x1 \zOg̋ԍW
     * @param y1 V
     * @param x2 V
     * @param y2 V
     */
    virtual void setRootQuadrant(int x1, int y1,
                                 int x2, int y2);

    /**
     * vfl؋Ԃɓo^
     * Ԕԍ͈͊OɂȂꍇ͖B
     * @param prm_pElem vf
     * @param tx1 vfΏۃIuWFNg̊Og̍W
     * @param ty1 V
     * @param tx2 V
     * @param ty2 V
     */
    void registerElem(GgafTreeElem<2u>* const prm_pElem,
                      int tx1, int ty1,
                      int tx2, int ty2);

    /**
     * l؋Ԃɓo^ĂSvfiԂɂj.
     * {\bhNAȂ΁A<BR>
     * registerElem() <BR>
     * ɂl؂֍ēxvfo^\ƂȂB
     */
    void clearAllElem();

    /**
     * fobOpBlؓo^󋵏óixW܂łΉĂȂj .
     */
    void putTree();

    virtual ~GgafLinearQuadtree();
};

}
#endif /*GGAFCORE_GGAFLINEARQUADTREE_H_*/

