#ifndef GGAFDXCORE_GGAFDXBOARDACTORD_H_
#define GGAFDXCORE_GGAFDXBOARDACTORD_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxFigureActor.h"

namespace GgafDxCore {

/**
 * Wϊς݃XvCgAN^[ .
 * GgafDxTransformedActor pA|SɃeNX`\t<BR>
 * eNX`̂PsNẐ܂܂Phbgŕ\ɎgpB<BR>
 * 2D[XvCgIȋ@\z肵AN^[B<BR>
 * ]@\(Z]̂)Agk@\@\B<BR>
 * @version 1.00
 * @since 2008/02/27
 * @author Masatoshi Tsuge
 */
class GgafDxBoardActor : public GgafDxFigureActor {
    /**
     * gps̂߁Aprivateoverride
     * @return
     */
    int isOutOfView() override {
        throwGgafCriticalException("gpsłB");
        return 0;
    }

    /**
     * gps̂߁Aprivateoverride
     * @return
     */
    bool isOutOfSpacetime() const override {
        throwGgafCriticalException("gpsłB");
        return false;
    }

    /**
     * gps̂߁Aprivateoverride
     * @return
     */
    GgafCore::GgafGroupHead* addSubGroupAsFk(actorkind prm_kind,
                                             GgafDxGeometricActor* prm_pGeoActor,
                                             int prm_x_init_local,
                                             int prm_y_init_local,
                                             int prm_z_init_local,
                                             int prm_rx_init_local,
                                             int prm_ry_init_local,
                                             int prm_rz_init_local) override {
        throwGgafCriticalException("gpsłB");
        return nullptr;
    }

    /**
     * gps̂߁Aprivateoverride
     * @return
     */
    GgafCore::GgafGroupHead* addSubGroupAsFk(GgafDxGeometricActor* prm_pGeoActor,
                                             int prm_x_init_local,
                                             int prm_y_init_local,
                                             int prm_z_init_local,
                                             int prm_rx_init_local,
                                             int prm_ry_init_local,
                                             int prm_rz_init_local) override {
        throwGgafCriticalException("gpsłB");
        return nullptr;
    }

public:
    /** [r]fIuWFNgւ̃|C^ */
    GgafDxBoardModel* const _pBoardModel;
    /** [r]GtFNg */
    GgafDxBoardEffect* const _pBoardEffect;
    /** [r]UVtbp[(ppAj) */
    GgafDxUvFlipper* const _pUvFlipper;

    GgafDxAlign _align;
    GgafDxValign _valign;

public:
    /**
     *
     * @param prm_name
     * @param prm_model_id
     * @param prm_effect_id
     * @param prm_technique
     */
    GgafDxBoardActor(const char* prm_name,
                     const char* prm_model_id,
                     const char* prm_effect_id,
                     const char* prm_technique );

    virtual void processDraw() override;

    virtual void processSettlementBehavior() override {
    }

    virtual ~GgafDxBoardActor(); //fXgN^

    virtual void setAlign(GgafDxAlign prm_align, GgafDxValign prm_valign);
    virtual void setAlign(GgafDxAlign prm_align);
    virtual void setValign(GgafDxValign prm_valign);

    virtual void setPositionAt(const GgafDxGeometricActor* prm_pActor) override;
    virtual void setPositionAt(const GgafDxGeoElem* prm_pGeoElem) override;
    virtual void setScale(scale s) override;
    virtual void setScale(scale sx, scale sy) override;
    virtual void setScale(scale sx, scale sy, scale sz) override;
    virtual void setScaleR(float prm_rate) override;
    virtual void setScaleR(float prm_x_rate, float prm_y_rate) override;
    virtual void setScaleR(float prm_x_rate, float prm_y_rate, float prm_z_rate) override;
    virtual void addScaleX(scale dsx) override {
        _sx += dsx;
    }
    virtual void addScaleY(scale dsy) override {
        _sy += dsy;
    }
    virtual void addScaleZ(scale dsz) override {
        _sz += dsz;
    }

    inline GgafDxUvFlipper* getUvFlipper() {
        return _pUvFlipper;
    }

    float getModelWidth();
    float getModelHeight();
};

}
#endif /*GGAFDXCORE_GGAFDXBOARDACTORD_H_*/
