#ifndef GGAFDXCORE_GGAFDXPUPPETEER_H_
#define GGAFDXCORE_GGAFDXPUPPETEER_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include <d3dx9.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

namespace GgafDxCore {

/**
 * pyb^[(l`) .
 * pyb^[́AŒ݂邳ꂽpybg(GgafDxD3DXAniMeshActor)𑀂_őA<BR>
 * lXȌ|(Aj[V)邱Ƃol(IuWFNg)łB<BR>
 * cOȂApybg͓2ނ̌|܂ł鎖o܂B<BR>
 * ŔApyb^[̘rQ{łBȂłˁB<BR>
 * gāApybg܂ĂB<BR>
 * <BR>
 * Iɂ́ÃNX́AID3DXAnimationController ̃bp[NXłB<BR>
 * őgbN 2 łB
 * ȓ́A<BR>
 * @ Aj[VuXs[hvyсud݁v́A{Aj[VgbNlA<BR>
 *    AAnimationSet ɕRtĊǗB<BR>
 *    Aj[Vؑ֎ɁAAj[VɕRÂuXs[hvyсud݁v
 *    gbNɐݒ肷悤ɂĂB<BR>
 * A tĐA[v̋@\<BR>
 * łB
 * @version 1.00
 * @since 2011/02/22
 * @author Masatoshi Tsuge
 */
class GgafDxPuppeteer : public GgafCore::GgafObject {
private:
    /** [r]pybg̃f */
    GgafDxD3DXAniMeshModel* _pModel;
    /** [r]pybg̃Aj[VRg[[ */
    ID3DXAnimationController* _pAc;

    /**
     * |([V) .
     */
    class Performance {
    public:
        /** Aj[VZbg */
        LPD3DXANIMATIONSET _pAnimationSet;
        /** P[v̎ */
        double _time_of_one_loop;
        /** [J^C */
        double _local_time;
        /** ڕW[v(1.5Ȃǂ̎w\) */
        double _target_loop;
        /** ڕWBXs[h(1.0ŒʏXs[hAŋtAj[V) */
        double _target_speed;
        /** ݂̃Xs[h */
        double _speed;
        /** Xs[h̉Zl */
        double _inc_speed;
        /** Xs[hZȂ true */
        bool   _is_shifting_speed;
        /** ڕWBd 0.0`1.0(͕s) */
        double _target_weight;
        /** ݂̏d */
        double _weight;
        /** d݂̉Zl */
        double _inc_weight;
        /** d݂ZȂ true */
        bool   _is_shifting_weight;
        /** [v@ */
        GgafDxPuppeteerMethod _method;
    public:
        Performance() {
            _pAnimationSet = nullptr;
            _time_of_one_loop   = 0.0;
            _local_time         = 0.0;
            _target_loop        = -1;
            _target_speed       = 1.0;
            _speed              = 1.0;
            _inc_speed          = 0.0;
            _is_shifting_speed  = false;
            _target_weight      = 1.0;
            _weight             = 1.0;
            _inc_weight         = 0.0;
            _is_shifting_weight = false;
            _method             = PLAY_LOOPING;
        }

        virtual ~Performance() {
        }
    };

    /** pyb^[̑_ */
    struct Stick {
        UINT _no;
        Performance* _pPerformance;
    };

public:
    /** [r]pybg */
    GgafDxD3DXAniMeshActor* _pPuppet;
    /** [r/w]pybg̎l^(|) */
    Performance* _paPerformances;
    /** [r]pybg̎l^(|)̐ */
    UINT _num_perform;
    /** [r/w]pAEp̃pyb^[̑_  [0]:p^[1]:Ep  */
    Stick _aStick[2];

public:
    /**
     * RXgN^ .
     * @param prm_pPuppet 
     * @return
     */
    explicit GgafDxPuppeteer(GgafDxD3DXAniMeshActor* prm_pPuppet);

    /**
     * vCĂ炤ipybgj .
     * @param prm_handed vCpyb^[̑_ (LEFT_HAND or RIGHT_HAND)
     * @param prm_prm_performance_no vC|ԍiAj[VRg[[̃Aj[VZbgIDɈvj
     * @param prm_loopnum ̌|̃[v 0.0 ` (P񔼃[v1.5Ƃ悤ɂw\B̐w(-1)Ŗ[vAj[V)
     * @param prm_target_speed ڕWXs[h ʏ -1.0 ` 0.0 ` 1.0 (1.0ŒʏXs[hAȏ\B̒lwŋtAj[VɂȂ)
     * @param prm_shift_speed_frames ڕWXs[hւ̓Bt[BXɃXs[hω܂B(0 wő prm_target_speed ɂȂ)
     * @param prm_target_weight ڕWd݁iAj[Vj 0.0 ` 1.0 (̐s)
     * @param prm_shift_weight_frames ڕWdւݓBt[AXɏd݂ωB(0 wő prm_target_weight ɂȂ)
     * @param prm_method
     */
    void play(GgafDxPuppeteerStick prm_handed,
              UINT prm_prm_performance_no,
              double prm_loopnum,
              double prm_target_speed,
              frame prm_shift_speed_frames,
              double prm_target_weight,
              frame prm_shift_weight_frames,
              GgafDxPuppeteerMethod prm_method = NO_CHENGE
    );

    /**
     * pyb^[̉E|ƍ| .
     */
    void exchangPerformance();

    void unpause(GgafDxPuppeteerStick prm_handed);
    void pause(GgafDxPuppeteerStick prm_handed);
    void stop();

    virtual void behave();
    virtual void work();
    virtual ~GgafDxPuppeteer();

};

}
#endif /*GGAFDXCORE_GGAFDXPUPPETEER_H_*/
