#ifndef GGAFDXCORE_GGAFDXMODELMANAGER_H_
#define GGAFDXCORE_GGAFDXMODELMANAGER_H_
#include "GgafDxCommonHeader.h"

#include "jp/ggaf/core/util/GgafResourceManager.hpp"

#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/util/XFile/framework/Frm_Mesh.h"
#include "jp/ggaf/dxcore/util/XFile/ToolBox/IOModel_X.h"

#define connectToModelTextureManager(X) ((GgafDxCore::GgafDxTextureConnection*)P_GOD->_pModelManager->_pModelTextureManager->connect((X), this))

namespace GgafDxCore {

/**
 * fCX^XǗ.
 * ɁAfXgɂێAfvꂽ<BR>
 * 邩A邢͐ςԂ𔻒f܂B<BR>
 * TODO:jƂNXŔ剻͂ȂAȂB
 * @version 1.00
 * @since 2009/02/01
 * @author Masatoshi Tsuge
 */
class GgafDxModelManager : public GgafCore::GgafResourceManager<GgafDxModel> {

private:
    GgafDxD3DXMeshModel*         createD3DXMeshModel(const char* prm_model_name, DWORD prm_dwOptions);
    GgafDxD3DXAniMeshModel*      createD3DXAniMeshModel(const char* prm_model_name);
    GgafDxD3DXMeshModel*         createDynaMeshModel(const char* prm_model_name);
    GgafDxSpriteModel*           createSpriteModel(const char* prm_model_name);
    GgafDxSpriteSetModel*        createSpriteSetModel(const char* prm_model_name);
    GgafDxMassSpriteModel*       createMassSpriteModel(const char* prm_model_name);
    GgafDxBoardModel*            createBoardModel(const char* prm_model_name);
    GgafDxBoardSetModel*         createBoardSetModel(const char* prm_model_name);
    GgafDxMassBoardModel*        createMassBoardModel(const char* prm_model_name);
    GgafDxMeshModel*             createMeshModel(const char* prm_model_name);
    GgafDxMeshSetModel*          createMeshSetModel(const char* prm_model_name);
    GgafDxMassMeshModel*         createMassMeshModel(const char* prm_model_name);
    GgafDxCubeMapMeshModel*      createCubeMapMeshModel(const char* prm_model_name);
    GgafDxCubeMapMeshSetModel*   createCubeMapMeshSetModel(const char* prm_model_name);
    GgafDxMorphMeshModel*        createMorphMeshModel(const char* prm_model_name);
    GgafDxMassMorphMeshModel*    createMassMorphMeshModel(const char* prm_model_name);
    GgafDxCubeMapMorphMeshModel* createCubeMapMorphMeshModel(const char* prm_model_name);
    GgafDxWorldBoundModel*       createWorldBoundModel(const char* prm_model_name);
    GgafDxPointSpriteModel*      createPointSpriteModel(const char* prm_model_name);
    GgafDxMassPointSpriteModel*  createMassPointSpriteModel(const char* prm_model_name);
    GgafDxPointSpriteSetModel*   createPointSpriteSetModel(const char* prm_model_name);
    GgafDxFramedBoardModel*    createFramedBoardModel(const char* prm_model_name);

public:

    struct SpriteXFileFmt {
        float width;
        float height;
        char texture_file[256];
        int row_texture_split;
        int col_texture_split;
    };

    class PointSpriteXFileFmt {
    public:
        float SquareSize;
        char TextureFile[256];
        int TextureSplitRowCol;
        int VerticesNum;
        D3DVECTOR* paD3DVECTOR_Vertices;
        D3DCOLORVALUE* paD3DVECTOR_VertexColors;
        int* paInt_InitUvPtnNo;
        float* paFLOAT_InitScale;
        PointSpriteXFileFmt() {
            SquareSize = 1;
            TextureSplitRowCol = 1;
            VerticesNum = 1;
            paD3DVECTOR_Vertices = nullptr;
            paD3DVECTOR_VertexColors = nullptr;
            paInt_InitUvPtnNo = nullptr;
            paFLOAT_InitScale = nullptr;
        }
        ~PointSpriteXFileFmt() {
            GGAF_DELETE_NULLABLE(paD3DVECTOR_Vertices);
            GGAF_DELETE_NULLABLE(paD3DVECTOR_VertexColors);
            GGAF_DELETE_NULLABLE(paInt_InitUvPtnNo);
            GGAF_DELETE_NULLABLE(paFLOAT_InitScale);
        }
    };

    static GgafDxTextureManager* _pModelTextureManager;
    /** JX^ev[gXt@Cǂݍݗp ID3DXFile ̃|C^ */
    static ID3DXFile* _pID3DXFile_sprx;
    static ID3DXFile* _pID3DXFile_psprx;
    static std::string getMeshFileName(std::string prm_model_name);
    static std::string getSpriteFileName(std::string prm_model_name);
    static std::string getPointSpriteFileName(std::string prm_model_name);

    static void obtainSpriteInfo(SpriteXFileFmt* pSpriteFmt_out, std::string prm_sprite_x_filename);
    static void obtainPointSpriteInfo(PointSpriteXFileFmt* pPointSpriteFmt_out, std::string prm_point_sprite_x_filename);
public:
    /**
     * RXgN^
     * @param prm_manager_name }l[W(eK{)
     */
    GgafDxModelManager(const char* prm_manager_name);

    /**
     * fIDɂAfIuWFNg𐶐 .
     * <pre>
     * fIĎ`
     * wf^Cv  + "/" + f`xƂȂĂB
     *  "D/MyShip"   --> GgafDxD3DXMeshModel ̃fBǂݍރt@C "MyShip.x"
     *  "d/MyShip"   --> GgafDxD3DXMeshModel ̃fBǂݍރt@C "MyShip.x"iD3DXMESH_DYNAMIC IvVقȂj
     *  "A/Hone"     --> GgafDxD3DXAniMeshModel ̃fBǂݍރt@C "Hone.x"
     *  "X/Enemy"    --> GgafDxMeshModel ̃fBǂݍރt@C "Enemy.x"
     *  "x/12/Enemy"- -> GgafDxMeshSetModel ̃fBǂݍރt@C "Enemy.x"B`IuWFNg 12 Zbg
     *  "x/Enemy"    --> GgafDxMeshSetModel ̃f(Zbgȗ\L)Bǂݍރt@C "Enemy.x"BZbgȗ͍ő 15 Zbg
     *  "t/12/Enemy"- -> GgafDxMassMeshModel ̃fBǂݍރt@C "Enemy.x"B`IuWFNg 12 Zbg
     *  "t/Enemy"    --> GgafDxMassMeshModel ̃f(Zbgȗ\L)Bǂݍރt@C "Enemy.x"BZbgȗ͍ő 15 Zbg
     *  "M/3/MyShip" --> GgafDxMorphMeshModel ̃fBǂݍރt@C "MyShip_0.x", "MyShip_1.x", "MyShip_2.x", "MyShip_3.x"BlȗsB
     *                   vC}f"MyShip_0.x"A[t^[Qbg1`3"MyShip_1.x", "MyShip_2.x", "MyShip_3.x"
     *  "S/Bomb"     --> GgafDxSpriteModel ̃fBǂݍރt@C "Bomb.sprx"B
     *  "s/5/Bomb"   --> GgafDxSpriteSetModel ̃fBǂݍރt@C "Bomb.sprx"B`IuWFNg 5 Zbg
     *  "s/Bomb"     --> GgafDxSpriteSetModel ̃f(Zbgȗ\L)Bǂݍރt@C "Bomb.sprx"BZbgȗ͍ő 18 Zbg
     *  "B/Font"     --> GgafDxBoardModel ̃fBǂݍރt@C "Font.sprx"B
     *  "b/10/Font"  --> GgafDxBoardSetModel ̃fBǂݍރt@C "Font.sprx"B`IuWFNg 10 Zbg
     *  "b/Font"     --> GgafDxBoardSetModel ̃fBǂݍރt@C "Font.sprx"BZbgȗ͍ő 28 Zbg
     *  "P/Star"     --> GgafDxPointSpriteModel ̃fBǂݍރt@C "Star.psprx"B`Zbg8
     *  "C"          --> GgafDxD3DXMeshModel ̃fBǂݍރt@C "cube.x"
     *  </pre>
     * @param prm_idstr fID
     * @param prm_p Rp[^Aݖgp
     * @return fIuWFNg
     */
    GgafDxModel* processCreateResource(const char* prm_idstr, void* prm_pConnector) override;

    /**
     * I[o[Ch
     */
    GgafCore::GgafResourceConnection<GgafDxModel>* processCreateConnection(const char* prm_idstr, GgafDxModel* prm_pResource) override;

    /**
     * fIuWFNgXg̊eCX^X̓eč\zB .
     * foCXXg̕AɌĂяo<BR>
     */
    void restoreAll();

    void onDeviceLostAll();

    void releaseAll();


    /** O`Model */
    static GgafDxModel* _pModelLastDraw;

    /**
     * f}l[W[Ǘ郂fXg̐擪擾
     * @return 擪̃f
     */
    GgafDxModelConnection* getFirstConnection() const {
        return (GgafDxModelConnection*)_pConn_first;
    }

    virtual ~GgafDxModelManager();
};

}
#endif /*GGAFDXCORE_GGAFDXMODELMANAGER_H_*/
